'use strict';

const config = require('cfg');

const multiparty = require('multiparty');

const mailer = require('../lib/mailer');
const SharePainter = require('../tools/sharePainter');

const painter = new SharePainter(config.share);

module.exports = (req, res) => {
    const form = new multiparty.Form();

    form.parse(req, function (err, fields, files) {
        if (err) {
            mailer('socialUpload.js:17<br><br>' + err);
        }

        let opacity = fields.opacity[0];

        const params = {
            opacity: opacity ? parseInt(opacity, 10) / 100 : 0,
            text: fields.text[0],
            url: fields.url[0],
            needLogo: fields.needLogo[0] === 'true',
            isInverted: fields.isInverted[0] === 'true'
        };

        if (files.file) {
            const file = files.file[0];
            params.backgroundImagePath = file.path;
        }

        res.send({
            base64: painter.generateShare(params)
        });
    });
};
