'use strict';

const config = require('cfg');

module.exports = () => {
    return function commonData(req, res, next) {
        req.commonData = {
            version: 'config.app.version',
            staticHost: config.static.host,
            debug: 'config.app.debug',
            host: req.headers.host,
            language: 'ru',
            contentRegion: req.tld.split('.').pop(),
            tld: req.tld,
            nonce: req.nonce,
            originalUrl: req.originalUrl,
            isDebug: ['local', 'testing'].indexOf(process.env.NODE_ENV) > -1 && req.query.debug,
            avatarService: config.avatarService,
            uploadMdsUrl: config.uploadMdsUrl,
            uploadSocialUrl: config.uploadSocialUrl
        };

        next();
    };
};
