'use strict';

const multer = require('multer');
const uploader = multer(multer.memoryStorage());

module.exports = function Router(app) {
    app.get('/', require('./controllers/index').mds);
    app.get('/social', require('./controllers/index').social);
    app.get('/pins', require('./controllers/index').pins);
    app.post('/upload-mds', uploader.single('file'), require('./controllers/mdsUpload'));
    app.post('/upload-social', require('./controllers/socialUpload'));
};
