'use strict';

const PainterBase = require('./painter');

class SharePainter extends PainterBase {
    /**
     * Затемняет фон
     * @param opacity
     * @private
     */
    _fillVeil(opacity) {
        this._fillRect({
            fillStyle: this._config.veil.color.replace('$', opacity)
        });
    }

    _fillTextarea(params) {
        this._fillText({
            offsetX: this._config.text.offsetX,
            offsetY: this._config.text.offsetY,
            text: params.text,
            color: params.isInverted ? this._config.text.invertedColor : this._config.text.color,
            font: this._config.text.font,
            fontSize: this._config.text.fontSize,
            lineHeight: this._config.text.lineHeight
        });
    }

    _fillUrl(params) {
        this._fillText({
            offsetX: this._config.url.offsetX,
            offsetY: this._config.url.offsetY,
            text: params.url,
            color: params.isInverted ? this._config.url.invertedColor : this._config.url.color,
            font: this._config.url.font,
            fontSize: this._config.url.fontSize,
            lineHeight: 0
        });
    }

    _fillLogo(isInverted) {
        const logoFile = isInverted ? this._config.logo.invertedLogo : this._config.logo.logo;
        const logoPath = `${__dirname}/${this._config.logo.path}/${logoFile}`;

        this._fillImage({
            offsetX: this._config.logo.offsetX,
            offsetY: this._config.logo.offsetY,
            imagePath: logoPath
        });
    }

    /**
     * Генерирует шэринг
     * @param params
     * @returns {string}
     */
    generateShare(params) {
        this._createCanvas();

        if (params.backgroundImagePath) {
            this._fillImage({
                imagePath: params.backgroundImagePath,
                needScale: true
            });
        } else {
            this._fillBackground();
        }

        if (params.opacity) {
            this._fillVeil(params.opacity);
        }

        if (params.needLogo) {
            this._fillLogo(params.isInverted);
        }

        if (params.text) {
            this._fillTextarea(params);
        }

        if (params.url) {
            this._fillUrl(params);
        }

        return this.base64;
    }
}

module.exports = SharePainter;
