module.exports = function (bh) {
    'use strict';
    bh.match('b-mds-form', function (ctx) {
        ctx
            .tag('form')
            .js({
                avatarService: bh.lib.global.avatarService,
                uploadUrl: bh.lib.global.uploadMdsUrl
            })
            .content([
                {
                    elem: 'form-row',
                    content: attachJson()
                },
                {
                    elem: 'form-response',
                    mods: {
                        hidden: 'yes'
                    },
                    content: inputJson()
                },
                {
                    elem: 'error',
                    mods: {
                        hidden: 'yes'
                    }
                },
                {
                    elem: 'form-row',
                    content: buttonJson()
                }
            ]);
    });

    function attachJson() {
        return {
            block: 'attach',
            mods: {
                size: 'm'
            },
            content: [
                {
                    block: 'button',
                    mods: {
                        size: 'm'
                    },
                    mix: [
                        {
                            block: 'attach',
                            elem: 'button'
                        }
                    ],
                    controlAttrs: {
                        autocomplete: 'off'
                    },
                    content: {
                        block: 'i-bem', elem: 'i18n', keyset: 'attach', key: 'button-text'
                    }
                },
                {
                    elem: 'holder',
                    content: {
                        block: 'i-bem', elem: 'i18n', keyset: 'attach', key: 'no-file'
                    }
                }
            ]
        };
    }

    function inputJson() {
        return {
            block: 'input',
            mods: {
                size: 's',
                clear: 'no'
            },
            content: {
                elem: 'control'
            }
        };
    }

    function buttonJson() {
        return [
            {
                block: 'button',
                mods: {
                    theme: 'action',
                    size: 'm'
                },
                type: 'submit',
                content: 'Загрузить изображение'
            },
            {
                block: 'spin2',
                mods: {
                    size: 'm'
                }
            }
        ];
    }
};
