'use strict';
/* global BEM, $ */
BEM.DOM.decl('b-mds-form', {
    onSetMod: {
        js: {
            inited: function () {
                this._form = this.domElem;
                this._attach = this.findBlockInside('attach');
                this._response = this.elem('form-response');
                this._error = this.elem('error');
                this._result = this.findBlockInside({
                    block: 'input',
                    modName: 'size',
                    modVal: 's'
                });
                this._button = this.findBlockInside({
                    block: 'button',
                    modName: 'theme',
                    modVal: 'action'
                });
                this._spinner = this.findBlockInside('spin2');

                this._avatarService = this.params.avatarService;
                this._uploadUrl = this.params.uploadUrl;

                this._bindEvents();
            }
        }
    },

    _bindEvents: function () {
        this._form.on('submit', this._onFormSubmit.bind(this));
    },

    /**
     * Клик по кнопке отправке формы
     * @param event
     * @private
     */
    _onFormSubmit: function (event) {
        event.preventDefault();

        this._result.clearInput();
        this._setLoadingView();
        this.setMod(this._response, 'hidden', 'yes');
        this.setMod(this._error, 'hidden', 'yes');

        var file = this._attach.findElem('control')[0].files[0];

        var formData = new FormData();

        formData.append('file', file);

        this
            ._sendData(formData)
            .done(this._onSuccess.bind(this))
            .fail(this._onError.bind(this))
            .always(this._setDefaultView.bind(this));
    },

    _sendData: function (formData) {
        return $.ajax({
            method: 'POST',
            url: this._uploadUrl,
            data: formData,
            processData: false,
            contentType: false
        });
    },

    /**
     * При успешной загрузке изображения в аватарницу, показываем пользователю URL до orig-изображения
     * @param data
     * @private
     */
    _onSuccess: function (data) {
        var hostname = this._avatarService.read.protocol + '://' + this._avatarService.read.hostname;

        if (!data['group-id']) {
            return;
        }

        this._result.val(hostname + data.sizes.orig.path);
        this.delMod(this._response, 'hidden');
        this._selectInputValue();
    },

    _onError: function (error) {
        this._error.text(JSON.stringify(error, null, 4));
        this.delMod(this._error, 'hidden');
        console.error(error);
    },

    /**
     * Ставим фокус на инпут и выделяем текст для лучшего UX
     * @private
     */
    _selectInputValue: function () {
        var control = this._result.findElem('control');

        control.focus();
        control[0].select();
    },

    _setLoadingView: function () {
        this._button.setMod('disabled', 'yes');
        this._attach.setMod('disabled', 'yes');
        this._spinner.setMod('progress', 'yes');
    },

    _setDefaultView: function () {
        this._button.delMod('disabled');
        this._attach.delMod('disabled');
        this._spinner.delMod('progress');
    }
});
