module.exports = function (blocks) {
    'use strict';
    blocks.declare('b-page', (data, page) => {
        const protocol = 'http';

        return [
            {
                block: 'i-global',
                params: {
                    lang: data.language,
                    tld: data.tld,
                    contentRegion: data.contentRegion,
                    secretKey: data.secretkey,
                    retpath: data.url,
                    host: `${protocol}://${data.host}`,
                    nonce: data.nonce,
                    id: 'avatars',
                    avatarService: data.avatarService,
                    uploadMdsUrl: data.uploadMdsUrl,
                    uploadSocialUrl: data.uploadSocialUrl
                }
            },
            {
                block: 'b-page',
                title: 'Служебная страница Advertising',
                head: [
                    {
                        elem: 'css',
                        url: `${data.staticHost}/desktop.bundles/${page}/_${page}.css`,
                        ie: false
                    },
                    {
                        elem: 'css',
                        url: `${data.staticHost}/desktop.bundles/${page}/_${page}`,
                        ie: true
                    },
                    {
                        elem: 'cc',
                        condition: 'IE 8',
                        content: {
                            elem: 'js',
                            url: 'https://yastatic.net/es5-shims/0.0.2/es5-shims.min.js'
                        }
                    },
                    {
                        elem: 'js',
                        url: 'https://yastatic.net/jquery/1.12.0/jquery.min.js'
                    },
                    {
                        elem: 'js',
                        url: `${data.staticHost}/desktop.bundles/${page}/_${page}.${data.language}.js`
                    },
                    {
                        elem: 'favicon',
                        url: 'https://yastatic.net/lego/_/pDu9OWAQKB0s2J9IojKpiS_Eho.ico'
                    }
                ],
                xUaCompatible: 'IE=edge',
                content: {
                    elem: 'wrapper',
                    content: [
                        {
                            block: 'header2'
                        },
                        blocks.exec(`b-page_type_${data.page}`, data),
                        {
                            block: 'b-debug', data: data
                        },
                        {
                            block: 'footer',
                            content: [
                                {
                                    elem: 'column',
                                    content: [
                                        {
                                            elem: 'link',
                                            url: `${protocol}://yandex.ru/adv/`,
                                            content: 'Рекламные технологии'
                                        },
                                        {
                                            elem: 'link',
                                            url: `${protocol}://${data.host}/`,
                                            content: 'MDS'
                                        },
                                        {
                                            elem: 'link',
                                            url: `${protocol}://${data.host}/social`,
                                            content: 'Шэйр-генератор'
                                        },
                                        {
                                            elem: 'link',
                                            url: `${protocol}://${data.host}/pins`,
                                            content: 'Картинки с пинами'
                                        }
                                    ]
                                },
                                {
                                    elem: 'column',
                                    elemMods: {
                                        side: 'right'
                                    },
                                    content: {
                                        block: 'copyright',
                                        start: 2016
                                    }
                                }
                            ]
                        }
                    ]
                }
            }
        ];
    });
};
