module.exports = function (bh) {
    bh.match('b-pin-row', function (ctx) {
        ctx
            .js({
                id: ctx.generateId()
            })
            .content([
                { elem: 'item', elemMods: { view: 'short' }},
                { elem: 'item', elemMods: { view: 'title' }},
                { elem: 'item', elemMods: { view: 'textarea' }},
                {
                    elem: 'remove',
                    content: {
                        block: 'button2',
                        mods: { theme: 'normal', size: 'm' },
                        icon: {
                            mods: { type: 'close' }
                        }
                    }
                }
            ]);
    });

    bh.match('b-pin-row__item_view_short', function (ctx) {
        ctx.content({
            block: 'input',
            mods: { size: 'm' },
            placeholder: 'Метка',
            content: { elem: 'control' }
        });
    });

    bh.match('b-pin-row__item_view_title', function (ctx) {
        ctx.content({
            block: 'input',
            mods: { size: 'm' },
            placeholder: 'Заголовок',
            content: { elem: 'control' }
        });
    });

    bh.match('b-pin-row__item_view_textarea', function (ctx) {
        ctx.content({
            block: 'input',
            mods: { size: 'm', type: 'textarea' },
            placeholder: 'Текст',
            content: {
                elem: 'control',
                attrs: { rows: '3' }
            }
        });
    });
};
