/* global BEM */
BEM.DOM.decl('b-pin-row', {
    onSetMod: {
        js: function () {
            this._removeButton = this.findBlockInside('remove', 'button2');
            this._labelInput = this.findBlockInside(this.elem('item', 'view', 'short'), 'input');
            this._titleInput = this.findBlockInside(this.elem('item', 'view', 'title'), 'input');
            this._textInput = this.findBlockInside(this.elem('item', 'view', 'textarea'), 'input');

            this._removeButton.on('click', this._removeRow, this);
            this._labelInput.on('change', this._onLabelChange, this);

            BEM.channel('pin').trigger('add-row', { id: this.params.id });
        }
    },

    _removeRow: function () {
        BEM.channel('pin').trigger('remove-row', { id: this.params.id });
        this.destruct();
    },

    _onLabelChange: function () {
        BEM.channel('pin').trigger('label-change', {
            id: this.params.id,
            value: this._labelInput.val()
        });
    },

    getData: function () {
        return {
            label: this._labelInput.val(),
            title: this._titleInput.val(),
            text: this._textInput.val()
        };
    }
});
