/* global BEM */
BEM.DOM.decl('b-pin', {
    onSetMod: {
        js: function () {
            this._label = this.elem('label');
            this._parent = this.domElem.parent();
            this._pinSize = this.domElem.width();

            this._moveHandler = this._moveAt.bind(this);

            this.domElem.on('mousedown', this._onMouseDown.bind(this));
            this.domElem.on('mouseup', this._onMouseUp.bind(this));
            this.domElem.on('dragstart', this._onDragStart.bind(this));
        }
    },

    _onMouseDown: function (e) {
        var offset = this.domElem.offset();

        this._shiftX = e.pageX - offset.left;
        this._shiftY = e.pageY - offset.top;

        this._moveAt(e);
        BEM.DOM.doc.on('mousemove', this._moveHandler);
    },

    _onMouseUp: function () {
        BEM.DOM.doc.off('mousemove', this._moveHandler);
    },

    _onDragStart: function () {
        return false;
    },

    _moveAt: function (e) {
        var left = e.pageX - this._parent.offset().left - this._shiftX;
        var top = e.pageY - this._parent.offset().top - this._shiftY;
        var rightLimit = this._parent.width() - this._pinSize;
        var bottomLimit = this._parent.height() - this._pinSize;

        if (left < 0 || top < 0 || left > rightLimit || top > bottomLimit) {
            this._onMouseUp();
            return;
        }

        this.domElem.css({
            left: left,
            top: top
        });
    },

    _getRelativeCoord: function (direction) {
        var offset = this.domElem.offset()[direction];
        var parentOffset = this._parent.offset()[direction];
        var absoluteCoord = offset - parentOffset + this._pinSize / 2;
        var base;

        if (direction === 'top') {
            base = 'height';
        } else if (direction === 'left') {
            base = 'width';
        }

        return Math.round(absoluteCoord / this._parent[base]() * 100000) / 1000 + '%';
    },

    changeLabel: function (labelText) {
        this._label.text(labelText);
    },

    getCoords: function () {
        return {
            coords: {
                top: this._getRelativeCoord('top'),
                left: this._getRelativeCoord('left')
            }
        };
    }
});
