module.exports = function (bh) {
    bh.match('b-pins', function (ctx) {
        ctx
            .js({
                avatarService: bh.lib.global.avatarService,
                uploadUrl: bh.lib.global.uploadMdsUrl
            })
            .content([
                { elem: 'attach' },
                { elem: 'form-wrapper' },
                { elem: 'modal' }
            ]);
    });

    bh.match('b-pins__attach', function (ctx) {
        ctx.content({
            block: 'attach',
            mods: {
                size: 'm'
            },
            content: [
                {
                    block: 'button',
                    mods: {
                        size: 'm'
                    },
                    mix: [
                        {
                            block: 'attach',
                            elem: 'button'
                        }
                    ],
                    controlAttrs: {
                        autocomplete: 'off'
                    },
                    content: {
                        block: 'i-bem', elem: 'i18n', keyset: 'attach', key: 'button-text'
                    }
                },
                {
                    elem: 'holder',
                    content: {
                        block: 'i-bem', elem: 'i18n', keyset: 'attach', key: 'no-file'
                    }
                }
            ]
        });
    });

    bh.match('b-pins__button', function (ctx) {
        ctx.content({
            block: 'button2',
            mods: {
                theme: 'action',
                size: 'm',
                action: 'get-code'
            },
            text: 'Получить код'
        });
    });

    bh.match('b-pins__form', function (ctx, json) {
        ctx.content([
            { elem: 'controls' },
            {
                elem: 'image',
                imageUrl: json.imageUrl
            },
            { elem: 'list' },
            { elem: 'button' }
        ]);
    });

    bh.match('b-pins__image', function (ctx, json) {
        ctx.content({
            tag: 'img',
            mix: { block: 'b-pins', elem: 'img' },
            attrs: { src: json.imageUrl }
        });
    });

    bh.match('b-pins__controls', function (ctx) {
        ctx.content([
            {
                block: 'tumbler',
                name: 'color',
                mods: { size: 's' },
                content: [
                    {
                        elem: 'option',
                        side: 'left',
                        content: 'Светлая картинка',
                        value: 'light'
                    },
                    {
                        elem: 'option',
                        side: 'right',
                        content: 'Тёмная картинкa',
                        value: 'dark'
                    }
                ]
            },
            {
                block: 'button2',
                mods: {
                    theme: 'normal',
                    size: 'm',
                    action: 'remove-form'
                },
                text: 'Очистить'
            }
        ]);
    });

    bh.match('b-pins__list', function (ctx) {
        ctx.content({
            block: 'button2',
            mods: { theme: 'normal', size: 'm', action: 'add-pin' },
            text: 'Добавить пин'
        });
    });

    bh.match('b-pins__spin', function (ctx) {
        ctx.content({
            block: 'spin2',
            mods: {
                size: 'm',
                progress: 'yes'
            }
        });
    });

    bh.match('b-pins__modal', function () {
        return {
            block: 'modal',
            mix: { block: 'b-pins', elem: 'modal' },
            mods: { theme: 'normal', autoclosable: 'yes' },
            content: {
                block: 'input',
                mods: { type: 'textarea', size: 's' },
                content: {
                    elem: 'control',
                    attrs: { rows: '40' }
                }
            }
        };
    });
};
