/* global BEM, BH, $ */
BEM.DOM.decl('b-pins', {
    onSetMod: {
        js: function () {
            this._avatarService = this.params.avatarService;
            this._uploadUrl = this.params.uploadUrl;
            this._attach = this.findBlockInside('attach', 'attach');
            this._formWrapper = this.elem('form-wrapper');
            this._modal = this.findBlockOn('modal', 'modal');
            this._actions = {
                'add-pin': this._addPinRow,
                'get-code': this._getCode,
                'remove-form': this._removeForm
            };

            this._attach.on('change', this._onAttachChange, this);

            BEM.blocks.button2.on('click', this._onButtonClick, this);
            BEM.channel('pin').on('add-row', this._addPinToImage, this);
            BEM.channel('pin').on('remove-row', this._removePinFromImage, this);
            BEM.channel('pin').on('label-change', this._changePinLabel, this);
        }
    },

    _onAttachChange: function () {
        var file = this._attach.findElem('control')[0].files[0];

        if (!file) {
            return;
        }

        var formData = new FormData();
        formData.append('file', file);

        this._sendData(formData)
            .done(this._onSuccess.bind(this))
            .fail(this._onError.bind(this));
    },

    _sendData: function (formData) {
        BEM.DOM.update(this._formWrapper, BH.apply({
            block: this.constructor.getName(),
            elem: 'spin'
        }));

        return $.ajax({
            method: 'POST',
            url: this._uploadUrl,
            data: formData,
            processData: false,
            contentType: false
        });
    },

    _onSuccess: function (data) {
        var hostname = this._avatarService.read.protocol + '://' + this._avatarService.read.hostname;

        if (!data['group-id']) {
            return;
        }

        BEM.DOM.update(this._formWrapper, BH.apply({
            block: this.constructor.getName(),
            elem: 'form',
            imageUrl: hostname + data.sizes.orig.path
        }));
    },

    _onError: function (error) {
        console.error(error);
    },

    _onButtonClick: function (event) {
        var action = event.block.getMod('action');
        var actionHandler = this._actions[action];

        if (typeof actionHandler === 'function') {
            actionHandler.call(this, event);
        }
    },

    _addPinRow: function () {
        BEM.DOM.prepend(this.findElem('list'), BH.apply({
            block: 'b-pin-row'
        }));
    },

    _findPinOnImage: function (id) {
        return this.findBlockInside(this.findElem('image'), {
            blockName: 'b-pin',
            modName: 'id',
            modVal: id
        });
    },

    _addPinToImage: function (e, data) {
        var imageWrapper = this.findElem('image');

        BEM.DOM.append(imageWrapper, BH.apply({
            block: 'b-pin',
            data: data
        }));
    },

    _removePinFromImage: function (e, data) {
        var pin = this._findPinOnImage(data.id);

        if (pin) {
            pin.destruct();
        }
    },

    _changePinLabel: function (e, data) {
        var pin = this._findPinOnImage(data.id);

        if (pin) {
            pin.changeLabel(data.value);
        }
    },

    _getPinCoords: function (id) {
        var pin = this._findPinOnImage(id);

        if (pin) {
            return pin.getCoords();
        }
    },

    _getPinsData: function () {
        var pinRows = this.findBlocksInside('list', 'b-pin-row');

        return pinRows.reduce(function (result, pinRow) {
            var pinData = $.extend(pinRow.getData(), this._getPinCoords(pinRow.params.id));

            result.push(pinData);
            return result;
        }.bind(this), []);
    },

    _getCode: function () {
        var isDark = this.findBlockInside('form', 'tumbler').hasMod('checked');
        var code = {
            theme: isDark ? 'dark' : 'light',
            image: this.findElem('img').attr('src'),
            pins: this._getPinsData()
        };

        this._modal
            .setMod('visible', 'yes')
            .findBlockInside('input')
            .val(JSON.stringify(code, null, 4))
            .findElem('control')[0]
            .select();
    },

    _removeForm: function () {
        this._attach.resetFile();
        BEM.DOM.destruct(this.findElem('form'));
    }
});
