module.exports = function (bh) {
    'use strict';
    bh.match('b-range-input', function (ctx) {
        ctx
            .js(true)
            .content([
                {
                    elem: 'label',
                    content: 'Затемнение'
                },
                {
                    elem: 'value',
                    content: 0
                },
                {
                    elem: 'input',
                    tag: 'input',
                    attrs: {
                        type: 'range',
                        value: 30,
                        list: 'opacity'
                    }
                },
                {
                    tag: 'datalist',
                    attrs: {
                        id: 'opacity'
                    },
                    content: [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100].map(item => optionJson(item))
                }
            ]);
    });

    function optionJson(item) {
        const option = {
            tag: 'option',
            attrs: {
                value: item
            }
        };

        if (item === 0 || item === 50 || item === 100) {
            option.attrs.label = item;
        }

        return option;
    }
};
