'use strict';
/* global BEM */
BEM.DOM.decl('b-range-input', {
    onSetMod: {
        js: {
            inited: function () {
                this._input = this.elem('input');
                this._value = this.elem('value');

                this._changeValue();

                this._bindEvents();
            }
        }
    },

    /**
     * Вещаем события на элементы
     * @private
     */
    _bindEvents: function () {
        this._input.on('input', this._changeValue.bind(this));
    },

    /**
     * Слушает изменения слайдера
     * @private
     */
    _changeValue: function () {
        this._value.text(this._input.val());
    }
});
