module.exports = function (bh) {
    'use strict';
    bh.match('b-social-form', function (ctx) {
        ctx
            .tag('form')
            .js({
                uploadUrl: bh.lib.global.uploadSocialUrl
            })
            .content([
                {
                    elem: 'row',
                    content: attachJson()
                },
                {
                    elem: 'row',
                    content: inputsJson()
                },
                {
                    elem: 'row',
                    content: buttonSubmitJson()
                },
                {
                    elem: 'row',
                    content: errorJson()
                }
            ])
        ;
    });

    function attachButtonJson() {
        return [
            {
                block: 'button',
                mods: {
                    size: 'm'
                },
                mix: [
                    {
                        block: 'attach',
                        elem: 'button'
                    }
                ],
                content: {
                    block: 'i-bem',
                    elem: 'i18n',
                    keyset: 'attach',
                    key: 'button-text'
                }
            },
            {
                elem: 'holder',
                content: {
                    block: 'i-bem',
                    elem: 'i18n',
                    keyset: 'attach',
                    key: 'no-file'
                }
            }
        ];
    }

    function attachJson() {
        return {
            block: 'attach',
            mods: {
                size: 'm'
            },
            content: attachButtonJson()
        };
    }

    function textareaInputJson() {
        return {
            block: 'input',
            mix: {
                block: 'b-social-form',
                elem: 'image-text'
            },
            mods: {
                type: 'textarea',
                size: 'm'
            },
            content: [
                {
                    elem: 'label',
                    content: 'Текст на картинке'
                },
                {
                    elem: 'control'
                }
            ]
        };
    }

    function urlInputJson() {
        return {
            block: 'input',
            mix: {
                block: 'b-social-form',
                elem: 'url'
            },
            mods: {
                size: 'm'
            },
            content: [
                {
                    elem: 'label',
                    content: 'Текст ссылки'
                },
                {
                    elem: 'control',
                    attrs: {
                        value: 'yandex.ru/adv'
                    }
                }
            ]
        };
    }

    function checkboxJson(elem, label) {
        return {
            block: 'checkbox',
            mix: {
                block: 'b-social-form',
                elem: elem
            },
            mods: {
                size: 'm',
                checked: 'yes'
            },
            content: {
                elem: 'label',
                content: label
            }
        };
    }

    function inputsJson() {
        return [
            {
                block: 'b-range-input'
            },
            textareaInputJson(),
            urlInputJson(),
            checkboxJson('need-logo', 'Логотип Яндекса', 'yes'),
            checkboxJson('is-inverted', 'Инвертировать цвета', 'no')
        ];
    }

    function buttonSubmitJson() {
        return [
            {
                block: 'button',
                mods: {
                    theme: 'action',
                    size: 'm'
                },
                type: 'submit',
                content: 'Сгенерировать шэринг'
            },
            {
                block: 'spin2',
                mods: {
                    size: 'm',
                    progress: 'no'
                }
            }
        ];
    }

    function errorJson() {
        return [
            {
                elem: 'error',
                mods: {
                    hidden: 'yes'
                }
            }
        ];
    }
};
