'use strict';
/* global BEM, $ */
BEM.DOM.decl('b-social-form', {
    onSetMod: {
        js: {
            inited: function () {
                this._form = this.domElem;
                this._uploadUrl = this.params.uploadUrl;

                this._attach = this.findBlockInside('attach');
                this._range = this.findBlockInside('b-range-input').elem('input');
                this._image = this.elem('image-text');
                this._url = this.elem('url');
                this._logoCheckbox = this.elem('need-logo');
                this._isInvertedCheckbox = this.elem('is-inverted');

                this._button = this.findBlockInside({
                    block: 'button',
                    modName: 'theme',
                    modVal: 'action'
                });
                this._spinner = this.findBlockInside('spin2');
                this._error = this.elem('error');

                this._bindEvents();
            }
        }
    },

    _bindEvents: function () {
        this._form.on('submit', this._onFormSubmit.bind(this));
    },

    /**
     * Клик по кнопке отправке формы
     * @param event
     * @private
     */
    _onFormSubmit: function (event) {
        event.preventDefault();

        this._setLoadingView();
        this.setMod(this._error, 'hidden', 'yes');

        var file = this._attach.findElem('control')[0].files[0];
        var opacity = this._range.val();
        var text = this._image.bem('input').val();
        var url = this._url.bem('input').val().trim();
        var needLogo = this._logoCheckbox.bem('checkbox').isChecked();
        var isInverted = this._isInvertedCheckbox.bem('checkbox').isChecked();

        var formData = new FormData();

        formData.append('file', file || null);

        formData.append('opacity', opacity);
        formData.append('text', text);
        formData.append('url', url);
        formData.append('needLogo', needLogo);
        formData.append('isInverted', isInverted);

        this
            ._sendData(formData)
            .done(this._onSuccess.bind(this))
            .fail(this._onError.bind(this))
            .always(this._setDefaultView.bind(this));
    },

    _sendData: function (formData) {
        return $.ajax({
            method: 'POST',
            url: this._uploadUrl,
            data: formData,
            processData: false,
            contentType: false
        });
    },

    /**
     * При успешной загрузке показываем превью шэринга и предлагаем его скачать
     * @param data
     * @private
     */
    _onSuccess: function (data) {
        this.trigger('success', data);
    },

    _onError: function (error) {
        this.trigger('error');

        this._error.text(JSON.stringify(error, null, 4));
        this.delMod(this._error, 'hidden');
        console.error(error);
    },

    _setLoadingView: function () {
        this._button.setMod('disabled', 'yes');
        this._spinner.setMod('progress', 'yes');
    },

    _setDefaultView: function () {
        this._button.delMod('disabled');
        this._spinner.delMod('progress');
    }
});
