module.exports = {
    parser: 'babel-eslint',
    env: {
        browser: true,
        commonjs: true,
        es6: true,
        node: true
    },
    extends: [
        'xo',
        'xo-react'
    ],
    parserOptions: {
        ecmaFeatures: {
            experimentalObjectRestSpread: true,
            jsx: true
        },
        ecmaVersion: '2017',
        sourceType: 'module'
    },
    plugins: [
        'react'
    ],
    rules: {
        indent: ['error', 4, { "SwitchCase": 1 }],
        quotes: ['error', 'single', {'avoidEscape': true}],
        'capitalized-comments': 0,
        'function-paren-newline': ['error', 'consistent'],
        'lines-between-class-members': 0,
        'no-alert': 0,
        'no-console': ['error', {allow: ['warn', 'error', 'debug', 'info', 'time', 'timeEnd']}],
        'react/destructuring-assignment': 0,
        'react/jsx-indent': ['error', 4],
        'react/jsx-indent-props': ['error', 4],
        'react/jsx-one-expression-per-line': 0,
        'react/jsx-sort-props': 0,
        'react/require-default-props': 0
    }
};
