/* eslint quotes: ["error", "single", {"avoidEscape": true}] */
const os = require('os');
const yastaticCSP = require('csp-preset-yastatic');

module.exports = {
    app: {
        baseUrl: '',
        fallbackHost: process.env.FALLBACK_HOST || 'yandex.ru'
    },

    blackbox: {
        api: 'blackbox.yandex-team.ru'
    },

    csp: {
        policies: {
            'default-src': ["'none'"],
            'script-src': [
                "'self'",
                "'unsafe-eval'",
                "'unsafe-inline'",
                '%nonce%',
                'mc.yandex.ru',
                'social.yandex.ru'
            ],
            'style-src': [
                "'self'",
                "'unsafe-inline'",
                'mc.yandex.ru',
                'maxcdn.bootstrapcdn.com'
            ],
            'font-src': [
                "'self'",
                'maxcdn.bootstrapcdn.com'
            ],
            'img-src': [
                "'self'",
                'data:',
                'avatars.yandex.net',
                'avatars.mds.yandex.net',
                'avatars.mdst.yandex.net',
                'mc.yandex.ru'
            ],
            'connect-src': [
                "'self'",
                'mc.yandex.ru'
            ]
        },
        presets: [yastaticCSP.script, yastaticCSP.style, yastaticCSP.font, yastaticCSP.image],
        useDefaultReportUri: true,
        serviceName: 'cm'
    },

    geobase: {
        server: 'http://geobase.qloud.yandex.ru',
        clientOptions: {
            timeout: 100
        }
    },

    htmlMinifier: {
        collapseWhitespace: true,
        collapseBooleanAttributes: true,
        removeAttributeQuotes: true,
        removeEmptyAttributes: true,
        removeRedundantAttributes: true
    },

    langdetect: {
        server: 'http://langdetect.qloud.yandex.ru',
        clientOptions: {
            timeout: 100
        },
        defaultLanguage: 'ru',
        availableLanguages: {
            ru: ['ru']
        }
    },

    logs: {
        name: 'cm',
        streams: [{
            level: 'info',
            stream: process.stdout
        }],
        excludes: ['*']
    },

    logoaas: {
        url: {
            protocol: 'http',
            host: 'yastatic.net',
            pathname: 'q/logoaas/v2',
            query: {
                size: '64'
            }
        },
        format: 'png',
        color: '000',
        invertedColor: 'fff'
    },

    ogPainter: {
        canvas: {
            width: 1200,
            height: 630
        },
        background: {
            color: '#E6E6E6'
        },
        veil: {
            color: 'rgba(0, 0, 0, $)'
        },
        fonts: [
            {
                family: 'YandexSansText',
                faces: [
                    {
                        fileName: 'YandexSansText-Regular.ttf',
                        weight: 'normal',
                        style: 'normal'
                    },
                    {
                        fileName: 'YandexSansText-Medium.ttf',
                        weight: '500',
                        style: 'normal'
                    }
                ],
                path: 'fonts'
            },
            {
                family: 'NotoSansSC',
                faces: [
                    {
                        fileName: 'NotoSansSC-Regular.otf',
                        weight: 'normal',
                        style: 'normal'
                    },
                    {
                        fileName: 'NotoSansSC-Medium.otf',
                        weight: '500',
                        style: 'normal'
                    }
                ],
                path: 'fonts'
            }
        ],
        text: {
            offsetX: 62,
            offsetY: 148,
            color: '#000',
            invertedColor: '#fff',
            font: {
                family: 'YandexSansText, NotoSansSC',
                weight: '500',
                style: 'normal',
                size: 64
            },
            lineHeight: 80
        },
        url: {
            offsetX: 78,
            offsetY: 550,
            color: '#767676',
            invertedColor: '#fff',
            font: {
                family: 'YandexSansText, NotoSansSC',
                weight: 'normal',
                style: 'normal',
                size: 32
            }
        },
        logo: {
            rightOffsetX: 63,
            offsetY: 497
        }
    },

    render: {
        entry: './app/build.js',
        webpackConfig: '../webpack.config.js',
        publicPath: '/'
    },

    server: {
        host: os.hostname(),
        port: process.env.QLOUD_HTTP_PORT || 8080
    },

    statics: {
        host: 'static',
        dir: './static'
    },

    s3Storage: {
        host: 's3.mds.yandex.net',
        internalProtocol: 'http',
        externalProtocol: 'https'
    },

    uatraits: {
        server: 'http://uatraits.qloud.yandex.ru',
        clientOptions: {
            timeout: 100
        }
    }
};
