const HTTP_SERVICES_TIMEOUT = 1000;

module.exports = {
    blackbox: {
        api: 'pass-test.yandex.ru'
    },

    csp: {
        policies: {
            'script-src': [
                "'self'",
                "'unsafe-eval'",
                "'unsafe-inline'",
                '%nonce%',
                'mc.yandex.ru',
                'social.yandex.ru'
            ],
            'style-src': [
                "'self'",
                "'unsafe-inline'",
                'mc.yandex.ru',
                'maxcdn.bootstrapcdn.com'
            ],
            'font-src': [
                "'self'",
                'maxcdn.bootstrapcdn.com'
            ]
        },
        useDefaultReportUri: false
    },

    geobase: {
        clientOptions: {
            timeout: HTTP_SERVICES_TIMEOUT
        }
    },

    langdetect: {
        clientOptions: {
            timeout: HTTP_SERVICES_TIMEOUT
        }
    },

    render: {
        hot: true
    },

    server: {
        host: 'localhost',
        port: 8080
    },

    statics: {
        host: '/static'
    },

    s3Storage: {
        host: 's3.mdst.yandex.net'
    },

    uatraits: {
        clientOptions: {
            timeout: HTTP_SERVICES_TIMEOUT
        }
    }
};
