const config = require('cfg');

const Express = require('express');

const bunyanLogger = require('express-bunyan-logger');
const cookieParser = require('cookie-parser');
const expressBlackbox = require('express-blackbox');
const expressHttpGeobase = require('express-http-geobase');
const expressHttpUatraits = require('express-http-uatraits');
const expressHttpLangdetect = require('express-http-langdetect');
const expressRenewBbSession = require('./middlewares/express-renew-bb-session');
const expressSecretKey = require('express-secretkey');
const expressTld = require('express-tld');
const expressYandexCsp = require('express-yandex-csp');
const expressYaFrameguard = require('express-ya-frameguard');
const expressYandexHostFallback = require('express-yandex-host-fallback');
const expressXff = require('express-x-forwarded-for-fix');
const expressYandexUid = require('express-yandexuid');
const helmet = require('helmet');

const appRender = require('./middlewares/app-render');

const indexController = require('./controllers/index');
const s3Api = require('./urls/s3-api');
const ogApi = require('./urls/og-api');

const app = new Express();

app.set('env', config.environment);
app.disable('x-powered-by');
app.enable('trust proxy');

if (config.environment !== 'production') {
    require('debug-http')();
}

app.use(expressYandexHostFallback({host: config.app.fallbackHost}));
app.use(cookieParser());
app.use(expressXff());
app.use(expressYandexCsp(config.csp));
app.use(helmet.noSniff());
app.use(helmet.xssFilter({setOnOldIE: true}));

app.use(appRender);

app.use(bunyanLogger(config.logs));

app.use(expressTld());
app.use(expressHttpGeobase(config.geobase));
app.use(expressYaFrameguard());
app.use(expressHttpUatraits(config.uatraits));
app.use(expressBlackbox(config.blackbox));
app.use(expressHttpLangdetect(config.langdetect));
app.use(expressYandexUid());
app.use(expressRenewBbSession());
app.use(expressSecretKey());

// TODO: увеличить maxAge, когда версия будет инкрементироваться
app.use('/static', Express.static(config.statics.dir, {
    fallthrough: false,
    maxAge: 3600 * 1000
}));

app.use('/s3-api', s3Api);
app.use('/og-api', ogApi);
app.get('*', indexController);

module.exports = app;
