const config = require('cfg');

const htmlMinify = require('html-minifier').minify;

function prepareData(req) {
    // this data will be available in your components via React Context;
    return {
        tld: req.tld || config.langdetect.defaultLanguage,
        lang: req.langdetect ? req.langdetect.id : config.langdetect.defaultLanguage,
        nonce: req.nonce,
        appVersion: process.env.APP_VERSION || null,
        staticHost: config.statics.host,
        s3StorageHost: config.s3Storage.host,
        s3StorageInternal: `${config.s3Storage.internalProtocol}://${config.s3Storage.host}`,
        s3StorageExternal: `${config.s3Storage.externalProtocol}://${config.s3Storage.host}`,
        hostUrl: `${req.protocol}://${req.get('Host')}`,
        baseUrl: config.app.baseUrl,
        bundle: 'index'
    };
}

module.exports = function (req, res, next) {
    const data = prepareData(req);

    res.render('index', req.url, data, config.render.hot)
        .then(({redirectUrl, html}) => {
            const compressedHtml = htmlMinify(html, config.htmlMinifier);

            if (redirectUrl) {
                switch (redirectUrl) {
                    case '404':
                        res.status(404).send(compressedHtml);
                        break;
                    default:
                        res.redirect(redirectUrl);
                }
            } else {
                res.send(compressedHtml);
            }
        })
        .catch(err => next(err));
};
