const config = require('cfg');

const OgPainter = require('./../tools/ogPainter');

const painter = new OgPainter(config.ogPainter);

module.exports = {
    generate: async (req, res) => {
        const params = req.body;

        params.isInverted = params.isInverted === 'true';

        if (req.file) {
            params.backgroundImage = req.file.buffer;
        }

        try {
            const ogImage = await painter.generateOg(params);

            res.json({ogImage});
        } catch (err) {
            console.error(err);

            res.status(err.statusCode || 400).send(err.message);
        }
    }
};
