const config = require('cfg');

const AWS = require('aws-sdk');

function defaultExecutor(req, res, methodName, params = {}) {
    const s3 = new AWS.S3({
        endpoint: `${config.s3Storage.internalProtocol}://${config.s3Storage.host}`,
        accessKeyId: req.get('Access-Key-Id'),
        secretAccessKey: req.get('Secret-Access-Key')
    });

    s3[methodName](params, (err, data) => {
        if (err) {
            console.error(err);

            res.status(err.statusCode || 400).send(err.message);
        } else {
            res.json(data);
        }
    });
}

module.exports = {
    listBuckets: (req, res) => {
        defaultExecutor(req, res, 'listBuckets');
    },

    createBucket: (req, res) => {
        defaultExecutor(req, res, 'createBucket', {
            Bucket: req.body.bucket
        });
    },

    listObjects: (req, res) => {
        defaultExecutor(req, res, 'listObjects', {
            Bucket: req.query.bucket,
            Delimiter: req.query.delimiter,
            Marker: req.query.marker,
            MaxKeys: req.query.max_keys,
            Prefix: req.query.prefix
        });
    },

    putObject: (req, res) => {
        const params = {
            Bucket: req.body.bucket,
            Key: req.body.key
        };

        if (req.file) {
            params.Body = req.file.buffer;
            params.ContentType = req.file.mimetype;
        }

        defaultExecutor(req, res, 'putObject', params);
    },

    deleteObject: (req, res) => {
        defaultExecutor(req, res, 'deleteObject', {
            Bucket: req.body.bucket,
            Key: req.body.key
        });
    },

    deleteObjects: (req, res) => {
        defaultExecutor(req, res, 'deleteObjects', {
            Bucket: req.body.bucket,
            Delete: {
                Objects: JSON.parse(req.body.keys).map(key => ({Key: key}))
            }
        });
    }
};
