require('babel-register')(require('../../../.babelrc').server);

const webpack = require('webpack');
const webpackConfig = require('../../../webpack/client.config');

const compiler = webpack(webpackConfig);

const hotMiddleware = require('webpack-hot-middleware');
const devMiddleware = require('webpack-dev-middleware');

const ssr = require('../../../src/ssr.jsx').default;

module.exports = [
    devMiddleware(compiler, {
        publicPath: webpackConfig.output.publicPath,
        historyApiFallback: true,
        stats: {
            colors: true
        }
    }),
    hotMiddleware(compiler),
    (req, res, next) => {
        res.render = ssr;
        next();
    }
];
