const MissingMiddlewareError = require('missing-middleware-error');

module.exports = function () {
    return function (req, res, next) {
        if (req.tld === undefined) {
            throw new MissingMiddlewareError('express-tld');
        }

        if (req.blackbox === undefined) {
            throw new MissingMiddlewareError('express-blackbox');
        }

        // @see http://doc.yandex-team.ru/Passport/AuthDevGuide/concepts/authorization-policy-resign.xml
        if (req.method === 'GET' && req.blackbox.status === 'NEED_RESET') {
            const retpath = req.headers['x-original-url'] || `${req.protocol}://${req.hostname}${req.originalUrl}`;
            const passUrl = `https://pass.yandex-team.${req.tld}/auth/update/?retpath=${encodeURIComponent(retpath)}`;

            res.redirect(passUrl);
            return;
        }

        next();
    };
};
