/* eslint new-cap: 0 */
const express = require('express');

const router = express.Router();

const multer = require('multer');
const uploader = multer(multer.memoryStorage());

const s3Api = require('./../controllers/s3-api');

router.get('/list-buckets', s3Api.listBuckets);
router.post(
    '/create-bucket',
    uploader.none([
        {name: 'bucket'}
    ]),
    s3Api.createBucket
);

router.get('/list-objects', s3Api.listObjects);
router.put(
    '/put-object',
    uploader.single('file'),
    s3Api.putObject
);
router.delete(
    '/delete-object',
    uploader.none([
        {name: 'bucket'},
        {name: 'key'}
    ]),
    s3Api.deleteObject
);
router.delete(
    '/delete-objects',
    uploader.none([
        {name: 'bucket'},
        {name: 'keys'}
    ]),
    s3Api.deleteObjects
);

module.exports = router;
