import React from 'react';
import {render} from 'react-dom';
import {Provider} from 'mobx-react';
import {BrowserRouter} from 'react-router-dom';
import {AppContainer} from 'react-hot-loader';

import configureStore from '../../mobx/configure-stores';

import App from './index';

const bundle = (App, stores, appData) => {
    const routerBasename = appData.baseUrl;

    return (
        <Provider {...stores}>
            <BrowserRouter basename={routerBasename}>
                <AppContainer>
                    <App appData={appData}/>
                </AppContainer>
            </BrowserRouter>
        </Provider>
    );
};

let stores;
let appData;

function updateBundle(NextApp) {
    const mount = document.getElementById('mount');
    render(bundle(NextApp, stores, appData), mount);
}

// TODO: вернуть hydrate, когда lego-on-react будет совместим с 16-м React'ом
export default function initBundle(state, data, hotRender) { // eslint-disable-line no-unused-vars
    stores = configureStore(state);
    appData = data;

    if (module.hot) {
        module.hot.accept('./index', () => {
            const NextApp = require('./index').default;
            updateBundle(NextApp);
        });
    }

    updateBundle(App);
}
