import React, {Component} from 'react';
import PropTypes from 'prop-types';
import Helmet from 'react-helmet';
import {Switch, Route} from 'react-router-dom';
import DevTools from 'mobx-react-devtools';

import YandexFavicon from 'react-yandex-favicon';

import Header from '../../components/header';
import S3Page from '../../components/s3-page';
import SocialForm from '../../components/social-form';
import Footer from '../../components/footer';
import NotFound from '../../components/not-found';

import './index.css';
import './themes/black.css';

export default class App extends Component {
    static propTypes = {
        appData: PropTypes.object.isRequired
    };

    static childContextTypes = {
        tld: PropTypes.string.isRequired,
        lang: PropTypes.string.isRequired,
        s3StorageHost: PropTypes.string.isRequired,
        s3StorageInternal: PropTypes.string.isRequired,
        s3StorageExternal: PropTypes.string.isRequired,
        hostUrl: PropTypes.string.isRequired
    };

    getChildContext() {
        const {
            tld,
            lang,
            s3StorageHost,
            s3StorageInternal,
            s3StorageExternal,
            hostUrl
        } = this.props.appData;

        return {
            tld,
            lang,
            s3StorageHost,
            s3StorageInternal,
            s3StorageExternal,
            hostUrl
        };
    }

    render() {
        const {lang} = this.props.appData;

        return (
            <div className="app">
                <Helmet>
                    <html lang={lang}/>
                    <title>CM</title>
                    <meta name="title" content="CM"/>
                    <meta name="description" content="Помощник контент-менеджеров"/>
                    <meta property="og:type" content="website"/>
                    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/latest/css/font-awesome.min.css"/>
                </Helmet>
                <YandexFavicon/>
                <main className="wrapper">
                    <Header/>
                    <section className="content">
                        <Switch>
                            <Route path="/" exact component={S3Page}/>
                            <Route path="/social" exact component={SocialForm}/>
                            <Route component={NotFound}/>
                        </Switch>
                    </section>
                    <Footer/>
                </main>
                {process.env.NODE_ENV === 'production' ? null : <DevTools/>}
            </div>
        );
    }
}
