import React from 'react';
import PropTypes from 'prop-types';
import {Provider} from 'mobx-react';
import {StaticRouter} from 'react-router-dom';
import {AppContainer} from 'react-hot-loader';

import configureStore from '../../mobx/configure-stores';

import App from './index';

export default function Bundle({appState, appData, location, context}) {
    const stores = configureStore(appState);
    const routerBasename = appData.baseUrl;

    return (
        <Provider {...stores}>
            <StaticRouter
                basename={routerBasename}
                location={location}
                context={context}
            >
                <AppContainer>
                    <App appData={appData}/>
                </AppContainer>
            </StaticRouter>
        </Provider>
    );
}

Bundle.propTypes = {
    appState: PropTypes.any,
    appData: PropTypes.any,
    location: PropTypes.string.isRequired,
    context: PropTypes.object.isRequired
};
