import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {observer, inject} from 'mobx-react';
import cn from 'classnames';

import Attach from 'lego-on-react/src/components/attach/attach.react';
import Button from 'lego-on-react/src/components/button/button.react';
import Spin from 'lego-on-react/src/components/spin/spin.react';

import 'lego-on-react/src/components/attach/attach.css';
import 'lego-on-react/src/components/button/button.css';
import 'lego-on-react/src/components/spin/spin.css';

import './index.css';

@inject('s3PageStore')
@observer
export default class ControlPanel extends Component {
    static propTypes = {
        s3PageStore: PropTypes.object.isRequired,
        onClickCreateBucket: PropTypes.func.isRequired,
        onFileChange: PropTypes.func.isRequired,
        onClickRefresh: PropTypes.func.isRequired,
        onClickCreateDir: PropTypes.func.isRequired,
        onClickChangeCredentials: PropTypes.func.isRequired
    };

    render() {
        return (
            <div
                className={cn('control-panel control-panel_button_hidden', {
                    'control-panel_attach_hidden': !this.props.s3PageStore.currentBucket
                })}
            >
                <Button
                    theme="action"
                    size="m"
                    onClick={this.props.onClickCreateBucket}
                    disabled={this.props.s3PageStore.isTryCreateBucket}
                    progress={this.props.s3PageStore.isTryCreateBucket}
                >
                    Создать бакет
                </Button>
                <Attach
                    theme="normal"
                    size="m"
                    holder="Файл не выбран"
                    onChange={this.props.onFileChange}
                    disabled={this.props.s3PageStore.isLoadingObject}
                >
                    Загрузить файл
                </Attach>
                <Spin size="m" progress={this.props.s3PageStore.isLoadingObject}/>
                <div className="control-panel__icons">
                    <i
                        className={
                            cn('fa fa-lg fa-refresh', {
                                'fa-refresh_spin': this.props.s3PageStore.isUpdating,
                                'fa-refresh_hidden': !this.props.s3PageStore.currentBucket
                            })
                        }
                        title="Обновить"
                        onClick={this.props.onClickRefresh}
                    />
                    <i
                        className={
                            cn('fa fa-lg fa-folder-open', {
                                'fa-folder-open_hidden': !this.props.s3PageStore.currentBucket
                            })
                        }
                        title="Создать папку"
                        onClick={this.props.onClickCreateDir}
                    />
                    <i
                        className="fa fa-lg fa-sign-out"
                        title="Сменить реквизиты"
                        onClick={this.props.onClickChangeCredentials}
                    />
                </div>
            </div>
        );
    }
}
