/* eslint quote-props: 0 */
import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import cn from 'classnames';

import './index.css';

export default class Error extends PureComponent {
    static propTypes = {
        errorMessage: PropTypes.string.isRequired
    };

    render() {
        return (
            <p className={cn('error', {'error_hidden': !this.props.errorMessage})}>
                {this.props.errorMessage}
            </p>
        );
    }
}
