import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';

import ItemControl from './../item-control';

import './index.css';

export default class ExplorerItem extends PureComponent {
    static propTypes = {
        item: PropTypes.object.isRequired,
        onClick: PropTypes.func.isRequired,
        onClickBack: PropTypes.func.isRequired,
        downloadLink: PropTypes.string.isRequired,
        onClickRemoveDir: PropTypes.func.isRequired,
        onClickRemoveFile: PropTypes.func.isRequired
    };

    getClassName(type) {
        switch (type) {
            case 'bucket':
                return 'fa-database';
            case 'dir-up':
                return 'fa-level-up';
            case 'dir':
                return 'fa-folder';
            case 'file':
                return 'fa-file-o';
            default:
                return '';
        }
    }

    formatSize(size) {
        return size ? `${Math.ceil(size / 1024)} КБ` : '';
    }

    formatDate(date) {
        return date ? new Date(date).toLocaleDateString() : '';
    }

    render() {
        const attrs = {
            'data-type': this.props.item.type,
            'data-prefix': this.props.item.commonPrefix,
            'data-name': this.props.item.name
        };

        return (
            <li
                className="explorer__item"
                {...attrs}
                onClick={this.props.item.type === 'dir-up' ? this.props.onClickBack : this.props.onClick}
            >
                <i className={`fa ${this.getClassName(this.props.item.type)}`}/>
                <span className="explorer__item-name" title={this.props.item.name}>
                    {this.props.item.name}
                </span>
                <span className="explorer__item-size">
                    {this.formatSize(this.props.item.size)}
                </span>
                <time className="explorer__item-created">
                    {this.formatDate(this.props.item.creationDate || this.props.item.lastModified)}
                </time>
                {
                    this.props.item.type === 'dir' ? (
                        <ItemControl
                            itemName={this.props.item.name}
                            onClickRemove={this.props.onClickRemoveDir}
                        />
                    ) : (
                        this.props.item.type === 'file' ? (
                            <ItemControl
                                itemName={this.props.item.name}
                                downloadLink={this.props.downloadLink}
                                onClickRemove={this.props.onClickRemoveFile}
                            />
                        ) : null
                    )
                }
            </li>
        );
    }
}
