import React, {Component} from 'react';
import PropTypes from 'prop-types';

import LegoFooter from 'lego-on-react/src/components/footer/footer.react';
import Copyright from 'lego-on-react/src/components/copyright/copyright.react';
import Link from 'lego-on-react/src/components/link/link.react';

import 'lego-on-react/src/components/footer/footer.css';
import 'lego-on-react/src/components/link/link.css';

export default class Footer extends Component {
    static contextTypes = {
        tld: PropTypes.string.isRequired,
        lang: PropTypes.string.isRequired
    };

    render() {
        return (
            <LegoFooter tld={this.context.tld} region={this.context.lang} start="2017">
                <LegoFooter.Column side="right">
                    <Copyright start="2017">
                        <Link
                            theme="normal"
                            url="http://wiki.yandex-team.ru/iddqd"
                            attrs={{target: '_blank'}}
                        >
                            iddqd
                        </Link>
                    </Copyright>
                </LegoFooter.Column>
            </LegoFooter>
        );
    }
}
