import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import cn from 'classnames';

import {CopyToClipboard} from 'react-copy-to-clipboard';

import './index.css';

export default class ItemControl extends PureComponent {
    static propTypes = {
        downloadLink: PropTypes.string,
        itemName: PropTypes.string.isRequired,
        onClickRemove: PropTypes.func.isRequired
    };

    state = {
        copied: false,
        elemCopy: null
    };

    handleCopyRef = elem => {
        this.setState({
            elemCopy: elem
        });
    };

    handleClickStopPropagation = e => {
        e.stopPropagation();
    };

    handleCopy = () => {
        this.setState({
            copied: true
        });

        this.state.elemCopy.addEventListener('animationend', () => {
            this.state.elemCopy.classList.remove('fa-link_clicked');

            this.setState({
                copied: false
            });
        });
    };

    // TODO: возвращать массив, когда вернёмся на 16-й React
    render() {
        return (
            <div className="item-control">
                <i className="fa fa-lg fa-trash" onClick={this.props.onClickRemove} title="Удалить"/>
                {this.props.downloadLink ? (
                    <div>
                        <CopyToClipboard
                            text={this.props.downloadLink}
                            onCopy={this.handleCopy}
                        >
                            <i
                                ref={this.handleCopyRef}
                                className={cn('fa fa-lg fa-link', {'fa-link_clicked': this.state.copied})}
                                onClick={this.handleClickStopPropagation}
                                title="Скопировать ссылку в буфер"
                            />
                        </CopyToClipboard>
                        <a href={this.props.downloadLink} target="_blank" rel="noopener noreferrer" title="Превью">
                            <i className="fa fa-lg fa-eye" onClick={this.handleClickStopPropagation}/>
                        </a>
                        <a href={this.props.downloadLink} download={this.props.itemName} title="Скачать файл">
                            <i className="fa fa-lg fa-download" onClick={this.handleClickStopPropagation}/>
                        </a>
                    </div>
                ) : null}
            </div>
        );
    }
}
