import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {observer, inject} from 'mobx-react';

import './index.css';

@inject('s3PageStore')
@observer
export default class Path extends Component {
    static contextTypes = {
        s3StorageHost: PropTypes.string.isRequired
    };

    static propTypes = {
        s3PageStore: PropTypes.object.isRequired
    };

    render() {
        return (
            <ol className="path">
                <i className="fa fa-home"/>
                {
                    [this.context.s3StorageHost, this.props.s3PageStore.currentBucket, this.props.s3PageStore.currentPrefix]
                        .filter(item => item)
                        .map((item, index) => index < 2 ? `${item}/` : item)
                        .map(item => <li key={item} className="path__item">{item}</li>)
                }
            </ol>
        );
    }
}
