import React, {PureComponent} from 'react';
import propTypes from 'prop-types';

import './index.css';

export default class RangeInput extends PureComponent {
    static propTypes = {
        value: propTypes.string,
        onChange: propTypes.func.isRequired
    };

    render() {
        return (
            <div className="range-input">
                <label className="range-input__label" htmlFor="range">
                    Затемнение
                </label>
                <div className="range-input__value">
                    {this.props.value}
                </div>
                <input
                    id="range"
                    type="range"
                    value={this.props.value}
                    list="opacity"
                    onChange={this.props.onChange}
                />
                <datalist id="opacity">
                    {
                        [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100].map(value => {
                            return value === 0 || value === 50 || value === 100 ? (
                                <option key={value} label={value} value={value}/>
                            ) : <option key={value} value={value}/>;
                        })
                    }
                </datalist>
            </div>
        );
    }
}
