import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {observer, inject} from 'mobx-react';

import TextInput from 'lego-on-react/src/components/textinput/textinput.react';
import Button from 'lego-on-react/src/components/button/button.react';

import 'lego-on-react/src/components/textinput/textinput.css';
import 'lego-on-react/src/components/button/button.css';

import Error from '../../components/error';

import './index.css';

@inject('s3PageStore')
@observer
export default class S3AuthForm extends Component {
    static contextTypes = {
        s3StorageHost: PropTypes.string.isRequired
    };

    static propTypes = {
        s3PageStore: PropTypes.object.isRequired
    };

    state = {
        accessKeyId: '',
        secretAccessKey: '',
        fullFilledAccessKeyId: false,
        fullFilledSecretAccessKey: false
    };

    componentDidMount() {
        this.props.s3PageStore.accessKeyId = localStorage.getItem('accessKeyId') || '';
        this.props.s3PageStore.secretAccessKey = localStorage.getItem('secretAccessKey') || '';

        this.setState({
            accessKeyId: this.props.s3PageStore.accessKeyId,
            secretAccessKey: this.props.s3PageStore.secretAccessKey,
            fullFilledAccessKeyId: this.props.s3PageStore.accessKeyId.length > 0,
            fullFilledSecretAccessKey: this.props.s3PageStore.secretAccessKey.length > 0
        });
    }

    handleAccessKeyIdInputChange = accessKeyId => {
        accessKeyId = accessKeyId.trim();

        this.setState({
            accessKeyId,
            fullFilledAccessKeyId: accessKeyId.length > 0
        });
    };

    handleSecretAccessKeyInputChange = secretAccessKey => {
        secretAccessKey = secretAccessKey.trim();

        this.setState({
            secretAccessKey,
            fullFilledSecretAccessKey: secretAccessKey.length > 0
        });
    };

    handleSubmit = () => {
        this.props.s3PageStore.accessKeyId = this.state.accessKeyId;
        this.props.s3PageStore.secretAccessKey = this.state.secretAccessKey;
        this.props.s3PageStore.isTryLogIn = true;

        this.props.s3PageStore.listBuckets();
    };

    render() {
        return (
            <section className="s3-auth-form">
                <h3>Ваши реквизиты для {this.context.s3StorageHost}</h3>
                <TextInput
                    text={this.state.accessKeyId}
                    theme="normal"
                    size="m"
                    placeholder="Ваш AccessKeyId"
                    hasClear
                    onChange={this.handleAccessKeyIdInputChange}
                />
                <TextInput
                    text={this.state.secretAccessKey}
                    theme="normal"
                    size="m"
                    placeholder="Ваш SecretAccessKey"
                    hasClear
                    onChange={this.handleSecretAccessKeyInputChange}
                />
                <Button
                    theme="action"
                    size="m"
                    onClick={this.handleSubmit}
                    disabled={!(this.state.fullFilledAccessKeyId && this.state.fullFilledSecretAccessKey)}
                    progress={this.props.s3PageStore.isTryLogIn}
                >
                    Авторизоваться
                </Button>
                {
                    this.props.s3PageStore.errorMessage ? (
                        <Error errorMessage={this.props.s3PageStore.errorMessage}/>

                    ) : null
                }
            </section>
        );
    }
}
