import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {observer, inject} from 'mobx-react';

import S3AuthForm from '../../components/s3-auth-form';
import Explorer from '../../components/explorer';

import './index.css';

@inject('s3PageStore')
@observer
export default class S3Page extends Component {
    static propTypes = {
        s3PageStore: PropTypes.object.isRequired
    };

    componentDidMount() {
        const accessKeyId = this.props.s3PageStore.accessKeyId;
        const secretAccessKey = this.props.s3PageStore.secretAccessKey;

        if (!this.props.s3PageStore.isLogIn && accessKeyId && secretAccessKey) {
            this.props.s3PageStore.isTryLogIn = true;

            this.props.s3PageStore.listBuckets();
        }
    }

    render() {
        return (
            <article className="s3-page">
                {this.props.s3PageStore.isLogIn ? <Explorer/> : <S3AuthForm/>}
            </article>
        );
    }
}
