import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {observer, inject} from 'mobx-react';

import Attach from 'lego-on-react/src/components/attach/attach.react';
import TextArea from 'lego-on-react/src/components/textarea/textarea.react';
import TextInput from 'lego-on-react/src/components/textinput/textinput.react';
import CheckBox from 'lego-on-react/src/components/checkbox/checkbox.react';
import Button from 'lego-on-react/src/components/button/button.react';
import Image from 'lego-on-react/src/components/image/image.react';
import Link from 'lego-on-react/src/components/link/link.react';

import 'lego-on-react/src/components/attach/attach.css';
import 'lego-on-react/src/components/textarea/textarea.css';
import 'lego-on-react/src/components/textinput/textinput.css';
import 'lego-on-react/src/components/checkbox/checkbox.css';
import 'lego-on-react/src/components/button/button.css';
import 'lego-on-react/src/components/image/image.css';
import 'lego-on-react/src/components/link/link.css';

import RangeInput from './../range-input/index';

import './index.css';

@inject('ogPageStore')
@observer
export default class SocialForm extends Component {
    static propTypes = {
        ogPageStore: PropTypes.object.isRequired
    };

    state = {
        file: null
    };

    handleFileChange = event => {
        this.setState({file: event.target.files[0]});
    };

    handleRangeChange = e => {
        this.props.ogPageStore.opacity = e.currentTarget.value;
    };

    handleTextOnImageChange = textOnImage => {
        this.props.ogPageStore.textOnImage = textOnImage;
    };

    handleUrlOnImageChange = urlOnImage => {
        this.props.ogPageStore.urlOnImage = urlOnImage;
    };

    handleTextLogoChange = textLogo => {
        this.props.ogPageStore.textLogo = textLogo;
    };

    handleIsInvertedChange = () => {
        this.props.ogPageStore.isInverted = !this.props.ogPageStore.isInverted;
    };

    handleSubmit = () => {
        const formData = new FormData();

        formData.append('file', this.state.file);
        formData.append('opacity', this.props.ogPageStore.opacity);
        formData.append('text', this.props.ogPageStore.textOnImage);
        formData.append('url', this.props.ogPageStore.urlOnImage);
        formData.append('textLogo', this.props.ogPageStore.textLogo);
        formData.append('isInverted', this.props.ogPageStore.isInverted);

        this.props.ogPageStore.generate(formData);
    };

    // TODO: возвращать массив, когда вернёмся на 16-й React
    render() {
        return (
            <form className="social-form">
                <Attach
                    theme="normal"
                    size="m"
                    holder="Файл не выбран"
                    onChange={this.handleFileChange}
                    disabled={this.props.ogPageStore.isProgress}
                >
                    {this.state.file ? 'Выбрать другой файл' : 'Выбрать файл' }
                </Attach>
                <RangeInput
                    value={this.props.ogPageStore.opacity}
                    onChange={this.handleRangeChange}
                />
                <div className="text-input">
                    <label htmlFor="text-on-image">Текст на картинке</label>
                    <TextArea
                        id="text-on-image"
                        text={this.props.ogPageStore.textOnImage}
                        theme="normal"
                        size="m"
                        onChange={this.handleTextOnImageChange}
                    />
                </div>
                <div className="text-input">
                    <label htmlFor="url-on-image">
                        Текст ссылки
                    </label>
                    <TextInput
                        id="url-on-image"
                        text={this.props.ogPageStore.urlOnImage}
                        theme="normal"
                        size="m"
                        hasClear
                        onChange={this.handleUrlOnImageChange}
                    />
                </div>
                <div className="text-input">
                    <label htmlFor="text-logo">
                        Логотип сервиса
                    </label>
                    <TextInput
                        id="text-logo"
                        text={this.props.ogPageStore.textLogo}
                        theme="normal"
                        size="m"
                        hasClear
                        onChange={this.handleTextLogoChange}
                    />
                </div>
                <div className="checkbox-group">
                    <CheckBox
                        theme="normal"
                        size="m"
                        checked={this.props.ogPageStore.isInverted}
                        onChange={this.handleIsInvertedChange}
                    >
                        Инвертировать цвета
                    </CheckBox>
                </div>
                <Button
                    theme="action"
                    size="m"
                    onClick={this.handleSubmit}
                    progress={this.props.ogPageStore.isProgress}
                >
                    Сгенерировать картинку
                </Button>
                {
                    this.props.ogPageStore.ogImage ? (
                        <Image
                            url={this.props.ogPageStore.ogImage}
                            alt="og-image"
                        />
                    ) : null
                }
                {
                    this.props.ogPageStore.ogImage ? (
                        <Link
                            theme="normal"
                            inner
                            url={this.props.ogPageStore.ogImage}
                            attrs={{download: 'share.png'}}
                        >
                            <Button
                                theme="normal"
                                size="m"
                            >
                                Скачать
                            </Button>
                        </Link>
                    ) : null
                }
            </form>
        );
    }
}
