import s3PageStore from './../stores/s3-page';

export default class BucketItemDir {
    constructor(data, type = 'dir') {
        this.item = {
            type: type,
            commonPrefix: data.Prefix,
            name: type === 'dir' ? data.Prefix.substring(s3PageStore.currentPrefixLen) : '..'
        };
    }

    get type() {
        return this.item.type;
    }

    get commonPrefix() {
        return this.item.commonPrefix;
    }

    get name() {
        return this.item.name;
    }
}
