import s3PageStore from '../../mobx/stores/s3-page';

export default class BucketItemFile {
    constructor(data, type = 'file') {
        this.item = {
            type: type,
            key: data.Key,
            lastModified: data.LastModified,
            size: data.Size,
            name: data.Key.substring(s3PageStore.currentPrefixLen)
        };
    }

    get type() {
        return this.item.type;
    }

    get lastModified() {
        return this.item.lastModified;
    }

    get size() {
        return this.item.size;
    }

    get name() {
        return this.item.name;
    }
}
