import {observable, action, runInAction} from 'mobx';

import errorHandler from './../../utils/error-handler';

class OgPageStore {
    @observable _opacity = '30';
    @observable _textOnImage = '';
    @observable _urlOnImage = 'yandex.ru/';
    @observable _textLogo = 'Яндекс';
    @observable _isInverted = true;

    @observable isProgress = false;
    @observable ogImage = null;

    get opacity() {
        return this._opacity;
    }

    @action('set opacity')
    _setOpacity(value) {
        this._opacity = value;
    }

    set opacity(value) {
        this._setOpacity(value);
    }

    get textOnImage() {
        return this._textOnImage;
    }

    @action('set textOnImage')
    _setTextOnImage(value) {
        this._textOnImage = value;
    }

    set textOnImage(value) {
        this._setTextOnImage(value);
    }

    get urlOnImage() {
        return this._urlOnImage;
    }

    @action('set urlOnImage')
    _setUrlOnImage(value) {
        this._urlOnImage = value;
    }

    set urlOnImage(value) {
        this._setUrlOnImage(value);
    }

    @action('set textLogo')
    _setTextLogo(value) {
        this._textLogo = value;
    }

    set textLogo(value) {
        this._setTextLogo(value);
    }

    get textLogo() {
        return this._textLogo;
    }

    get isInverted() {
        return this._isInverted;
    }

    @action('set isInverted')
    _setIsInverted(value) {
        this._isInverted = value;
    }

    set isInverted(value) {
        this._setIsInverted(value);
    }

    @action('generate og-image')
    generate(formData) {
        fetch('og-api/generate', {
            method: 'POST',
            credentials: 'include',
            body: formData
        })
            .then(res => res.status === 200 ? Promise.resolve(res) : Promise.reject(res))
            .then(res => res.json())
            .then(json => {
                this.ogImage = json.ogImage;
                this.isProgress = false;
            })
            .catch(async err => {
                err = await errorHandler(err);

                console.error(err);

                runInAction(() => {
                    this.isProgress = false;
                });
            });
    }
}

const ogPageStore = new OgPageStore();

export default ogPageStore;
