const os = require('os');

const csp = require('express-yandex-csp');
const defaultPreset = require('@yandex-int/yandex-logger/middleware/preset-default');
const deployStream = require('@yandex-int/yandex-logger/streams/deploy');

module.exports = {
    server: {
        port: process.env.QLOUD_HTTP_PORT || 8000,
        hostname: os.hostname()
    },

    app: {
        domains: 'by,com,com.tr,kz,ru,cn',
        logRequests: false,
        version: process.env.APP_VERSION
    },

    cache: {
        options: {
            max: 1000
        },
        ttl: {
            companiesFilters: 60 * 1000, // 1 min
            companiesSlugs: 60 * 1000 // 1 min
        }
    },

    forms: {
        url: 'https://forms.yandex.ru/surveys/',
        contactUrl: '/send',
        subscribeUrl: '/subscribe',
        transactionPath: '/transaction'
    },

    router: {
        adv: '/adv',
        vda: '/vda'
    },

    bunker: {
        project: 'adv-www',
        api: 'http://bunker-api.yandex.net/v1',
        updateInterval: 15 * 60 * 1000,
        directories: true
    },

    bunkerApi: {
        baseUrl: 'https://bunker.yandex-team.ru',
        csrfTokenAge: 1000 * 60 * 60 * 24, // 1 день
        paths: {
            ls: '/ls',
            cat: '/cat',
            tree: '/tree',
            store: '/~store',
            publish: '/~publish'
        }
    },

    i18n: {
        default: 'en'
    },

    blackbox: {
        emails: 'getdefault',
        getphones: 'bound',
        maxChunkSize: 100,
        timeout: 2000,
        retries: 5,
        family: 6
    },

    mail: {
        smtp: 'yabacks.mail.yandex.net'
    },

    direct: {
        protocol: 'http',
        pathname: 'UserRole',
        timeout: 1000
    },

    view: {
        templateRoot: `${__dirname}/../out/static`,
        block: 'b-page',
        templateExt: 'bh.js',
        cwd: `${__dirname}/../out/static`
    },

    csp: {
        presets: {
            dataUri: require('./csp/presets/data-uri'),
            mail: require('./csp/presets/mail'),
            passport: require('./csp/presets/passport'),
            webvisor: require('./csp/presets/webvisor'),
            metrika: require('./csp/presets/metrika'),
            browserUpdater: require('./csp/presets/browser-updater'),
            ...require('./csp/presets/yastatic')
        },
        policies: {
            'connect-src': [
                csp.SELF, 'yandex.st'
            ],
            'default-src': [
                csp.NONE
            ],
            'img-src': [
                csp.SELF, '*.yandex.net:*', '*.yandex.ru:*', 'yandex.st', 'yastatic.net',
                'a.tile.openstreetmap.org', 'img.youtube.com'
            ],
            'script-src': [
                csp.NONCE, csp.EVAL, csp.INLINE,
                'api-maps.yandex.ru', 'yastatic.net', 'yandex.ru',
                'site.yandex.net', 'sitesearch-suggest.yandex.ru',
                'an.yandex.ru'
            ],
            'style-src': [
                csp.INLINE, 'yastatic.net'
            ],
            'frame-src': ['forms.yandex.ru', 'player.video.yandex.net', 'video.yandex.ru',
                'www.youtube-nocookie.com', 'vda.yandex.net', 'slides.com', 'download.yandex.ru',
                'download.yandex.net', '*.cdn.yandex.net', 'proctoring.expert.yandex.net',
                'proctoring-no-cookie.commerce-int.yandex.net', 'frontend.vh.yandex.ru',
                'lp-constructor.yandex-team.ru', 'streaming.video.yandex.ru',
                'passport.yandex.ru', 'passport.yandex.com', 'passport.yandex.com.tr', 'passport.yandex.kz', 'passport.yandex.by',
                'yandex.ru/chat', 'music.yandex.ru', 'datalens.yandex'
            ],
            'child-src': ['forms.yandex.ru', 'video.yandex.ru', 'music.yandex.ru'],
            'object-src': ['yandex.st'],
            'media-src': ['yastatic.net', 'download.yandex.ru', '*.cdn.yandex.net'],
            'font-src': ['yastatic.net'],
            'frame-ancestors': [csp.SELF, 'passport.yandex.ru', 'passport.yandex.com', 'passport.yandex.com.tr', 'passport.yandex.kz', 'passport.yandex.by']
        },
        serviceName: 'adv-front',
        useDefaultReportUri: true
    },

    comdi: {
        supportedBrowsers: [
            { name: 'MSIE', version: 8 },
            { name: 'Chrome', version: 10 },
            { name: 'Opera', version: 11 },
            { name: 'Firefox', version: 4 },
            { name: 'Mozilla', version: 4 },
            { name: 'Safari', version: 5 }
        ]
    },

    blogs: {
        news: {
            default: 'adv-news',
            com: 'adv-news-com',
            'com.tr': 'adv-news-com-tr',
            'cn': 'adv-news-cn'
        },
        partners: {
            default: 'adv-partners'
        },
        edu: {
            ru: 'edu-expert-ru',
            com: 'edu-expert-en'
        },
        maxQueryLength: 2000 // При слишком длинных запросах API Блогов отвечает с кодом 400
    },

    avatarSource: {
        protocol: 'https',
        host: 'yapic.yandex.ru',
        path: 'get',
        size: 'islands-middle'
    },

    passport: {
        protocol: 'https',
        paths: {
            auth: 'auth',
            passport: 'passport',
            resign: 'resign',
            update: 'auth/update'
        }
    },

    limitPartnersNews: 12,
    limitNews: 20,
    limitNewsIndexPage: 4,
    limitMaterials: 10,

    morda: {
        protocol: 'https',
        ru: {
            host: 'yandex.ru'
        },
        com: {
            host: 'yandex.com'
        },
        by: {
            host: 'yandex.ru'
        },
        kz: {
            host: 'yandex.ru'
        },
        'com.tr': {
            host: 'yandex.com.tr'
        },
        cn: {
            host: 'yandex.com'
        }
    },

    bunkerLang: {
        ru: 'ru',
        by: 'by',
        kz: 'kz',
        com: 'en',
        'com.tr': 'tr',
        cn: 'cn',
        default: 'ru'
    },

    tldToLang: {
        ru: 'ru',
        by: 'ru',
        kz: 'ru',
        com: 'en',
        'com.tr': 'tr',
        cn: 'zh-Hans',
        default: 'ru'
    },

    tldToBlogLang: {
        ru: 'ru-RU',
        by: 'ru-RU',
        kz: 'ru-RU',
        com: 'en-EN',
        'com.tr': 'tr-TR',
        cn: 'en-EN',
        default: 'ru-RU'
    },

    shareServices: {
        ru: ['vkontakte', 'twitter', 'telegram', 'odnoklassniki'],
        by: ['vkontakte', 'twitter', 'telegram', 'odnoklassniki'],
        kz: ['vkontakte', 'twitter', 'telegram', 'odnoklassniki'],
        com: ['vkontakte', 'twitter'],
        'com.tr': ['vkontakte', 'twitter'],
        cn: ['sinaWeibo', 'renren', 'tencentWeibo'],
        default: ['vkontakte', 'twitter', 'telegram', 'odnoklassniki']
    },

    geoIdByTld: {
        ru: 225,
        by: 149,
        kz: 159,
        'com.tr': 983,
        cn: 134
    },

    mapsApi: '//api-maps.yandex.ru/2.1/',

    share: '//yastatic.net/share2/share.js',

    ymapsLocales: {
        ru: 'ru_RU',
        by: 'ru_RU',
        kz: 'ru_RU',
        com: 'en_US',
        cn: 'en_US',
        'com.tr': 'tr_TR'
    },

    favicon: {
        ru: 'https://yastatic.net/s3/vda/i/v2/favicon_ru.ico',
        by: 'https://yastatic.net/s3/vda/i/v2/favicon_ru.ico',
        kz: 'https://yastatic.net/s3/vda/i/v2/favicon_ru.ico',
        com: 'https://yastatic.net/s3/vda/i/v2/favicon_en.ico',
        'com.tr': 'https://yastatic.net/s3/vda/i/v2/favicon_en.ico',
        cn: 'https://yastatic.net/s3/vda/i/v2/favicon_en.ico',
        default: 'https://yastatic.net/s3/vda/i/v2/favicon_ru.ico'
    },

    hljs: {
        js: 'https://yastatic.net/s3/vda/i/vendors/hljs/highlight.pack.js',
        css: 'https://yastatic.net/s3/vda/i/vendors/hljs/default.min.css'
    },

    uatraitsDefaultValues: {
        isMobile: false,
        BrowserName: 'YandexBrowser',
        BrowserVersion: '16.3.0.7847',
        SVGSupport: true,
        skipErrors: true
    },

    uatraits: {
        skipErrors: true
    },

    commonMetrikaCounters: [],
    metrikaCounters: [],
    metrikaCountersParams: {
        clickmap: true,
        trackLinks: true,
        accurateTrackBounce: true
    },

    partnersAccessRoles: [
        'agency',
        'limited_support',
        'manager',
        'media',
        'placer',
        'super',
        'superreader',
        'support'
    ],

    browserUpdater: 'https://yastatic.net/browser-updater/v1/script.js',

    regions: {
        ru: {
            name: 'Россия'
        },
        by: {
            name: 'Беларусь'
        },
        kz: {
            name: 'Казахстан'
        },
        uz: {
            name: 'Узбекистан'
        },
        'com.tr': {
            name: 'Türkçe'
        },
        cn: {
            name: '中文'
        },
        com: {
            name: 'English'
        }
    },

    regionsOrder: ['ru', 'by', 'kz', 'com', 'cn', 'com.tr'],

    regionsWithCourses: ['ru', 'com', 'cn'],

    agenciesRegionsOrder: ['ru', 'by', 'kz', 'uz', 'com', 'cn', 'com.tr'],

    sources: {
        adroll: {
            languages: ['com'],
            path: '/adroll'
        },
        comdi: {
            path: '/comdi'
        }
    },

    subscribe: {
        protocol: 'https',
        account: 'sales',
        path: '/subscription/request',
        transactionalMaillist: 'SVMRRNZ2-WUM1'
    },

    tvm: {
        serverUrl: `${process.env.DEPLOY_TVM_TOOL_URL}/tvm`,
        token: process.env.TVMTOOL_LOCAL_AUTHTOKEN || 'tvmtool-development-access-token',
        cacheMaxAge: 1000 * 60 * 9, // 9 min
        throwError: true
    },

    captcha: {
        apiHost: 'api.captcha.yandex.net',
        type: {
            ru: 'ocr',
            com: 'ocr_en'
        }
    },

    dashboard: {
        task: {
            schedule: 'sec 0 * * * *', // Запуск раз в час в первую минуту
            module: `${__dirname}/../server/lib/dashboard`, // Модуль, который будет запущен
            timeZone: 'Europe/Moscow' // Таймзона для выполнения
        }
    },

    mordaLogo: 'https://avatars.mds.yandex.net/get-adv/61206/2a0000015fb9738e66e2d58133423d251a88/orig',

    story: {
        domains: ['ru', 'com', 'kz']
    },

    yandexBase: 'https://yandex.',

    searchIds: {
        ru: '2320799',
        by: '2320906',
        kz: '2320907',
        com: '2320908'
    },

    instantArticlesPageId: 154524477903681,

    certificatesIcons: {
        'direct_en': '42259/2a0000015dbbe710a9e4f94f1e481a2a212a',
        'metrika_en': '28496/2a0000015dbbed5ea0f336b32339668ffb62',
        'direct-pro': '61206/2a000001662eb2757d948dd1adb3d14908eb',
        direct: '50237/2a0000015dbbe941454fd87bba823be88a69',
        metrika: '60663/2a0000015dbbedbaef95a996c8efcf4684fa',
        market: '50995/2a0000015de45c607b2937455ac97db767ac',
        publisher: '28496/2a0000015e5fed04b60097c1eceb22cd5635',
        rsya: '61206/2a0000015de5d57e20be5e75d1efa6ebb32b'
    },

    avatarsBase: 'https://avatars.mds.yandex.net/get-adv/',

    checkForm: {
        url: 'http://checkform2-test.n.yandex-team.ru/check',
        params: {
            form: true,
            method: 'POST'
        }
    },

    emojisSupportBrowsers: [
        { name: 'chrom', version: 51 },
        { name: 'opera', version: 36 },
        { name: 'firefox', version: 52 },
        { name: 'yandex', version: 16 },
        { name: 'safari', version: 12 }
    ],

    reactRender: {
        isHot: false
    },

    langs: ['ru', 'en'],

    static2: {
        dir: `${__dirname}/../dist`
    },

    caseCategory: {
        // Аналог поля постов в блогах, используется только в материалах для ru, kz и by
        displayName: 'Кейс'
    },

    statvalue: {
        metrika: {
            options: {
                clickmap: true,
                trackLinks: true,
                accurateTrackBounce: true,
                webvisor: true
            }
        },
        mordaHost: 'https://direct.yandex.ru'
    },

    logger: {
        fields: {
            environment: process.env.NODE_ENV,
            release: process.env.APP_VERSION
        },
        middleware: [
            defaultPreset()
        ],
        name: 'adv-front',
        streams: [
            {
                level: 'info',
                stream: deployStream()
            }
        ]
    },

    htmlMappings: {
        '&shy;': '',
        '&nbsp;': ' ',
        '&#160;': ' ',
        '&mdash;': '—',
        '&ndash;': '–',
        '&laquo;': '«',
        '&raquo;': '»'
    },

    agencies: {
        groupsByCountryGeoId: {
            225: 'offices', // Russia
            149: 'offices', // Belarus
            default: 'partners'
        },
        availableGroups: ['main', 'offices', 'partners'],
        agency: {
            logo: {
                default: 'https://yastatic.net/s3/vda/i/images/agency.png'
            },
            description: {
                maxPreviewLength: 250,
                maxLength: 900
            }
        }
    },

    cmnt: {
        apiKey: process.env.CMNT_API_KEY,
        initPath: '/init-http',
        briefPath: '/brief',
        signPath: '/sign',
        maxPostsSlugs: 60,
        officiality: {
            logins: ['adv', 'ya.sup.asap']
        }
    },

    reactScript: 'https://yastatic.net/react/16.8.4/react-with-dom-and-polyfills.min.js',

    promos: {
        host: 'https://vda-testing.commerce-int.yandex.net'
    }
};
