const _ = require('lodash');
const lineStream = require('yandex-logger/streams/line');

const HTTP_SERVICES_TIMEOUT = 300;

module.exports = {
    app: {
        version: 'local'
    },

    backend: {
        baseUrl: 'https://adv-backend-test.in.yandex-team.ru/v1/'
    },

    bunker: {
        api: 'http://bunker-api-dot.yandex.net/v1',
        version: 'latest',
        updateInterval: 30000
    },

    blackbox: {
        api: 'pass-test.yandex.ru',
        getServiceTicket: req => _.get(req, 'tvm.tickets.blackbox-testing.ticket')
    },

    passport: {
        host: {
            ru: 'passport-test.yandex.ru',
            com: 'passport-test.yandex.com',
            'com.tr': 'passport-test.yandex.com.tr',
            by: 'passport-test.yandex.by',
            kz: 'passport-test.yandex.kz'
        }
    },

    static: {
        host: '/vda/static',
        dir: `${__dirname}/../static`,
        noCache: true
    },

    static2: {
        baseUrl: '/vda/static2',
        frozenPath: '/_',
        version: ''
    },

    router: {
        l7Subdomain: 'yandex',
        commonSubdomains: ['yandex-ad']
    },

    view: {
        templateRoot: `${__dirname}/../static`,
        cwd: `${__dirname}/../static`,
        dev: true
    },

    csp: {
        presets: {
            self: require('./csp/presets/local'),
            cmnt: require('./csp/presets/ya-cmnt-testing')
        }
    },

    uatraits: {
        server: 'http://uatraits-test.qloud.yandex.ru',
        clientOptions: {
            timeout: HTTP_SERVICES_TIMEOUT
        }
    },

    blogs: {
        host: 'https://adv-blogs-pumpkin-test.commerce-int.yandex-team.ru/v1',
        rss: 'https://yablogs-testing.common.yandex.ru/blog',
        commentsMigration: 'http://yablogs-api-test.common.yandex.ru/v1'
    },

    dashboard: {
        interest: 'http://back-test.advq.yandex.ru/advertising-categories/stats.json',
        updateInterval: 60 * 60 * 1000,
        cpc: 'http://bssoap-test01g.yandex.net/export/export_adv-stat.cgi'
    },

    direct: {
        hostname: 'intapi.test.direct.yandex.ru',
        port: '9000'
    },

    sources: {
        url: 'https://vda-testing.commerce-int.yandex.net'
    },

    subscribe: {
        auth: {
            default: process.env.SUBSCRIPTION_KEY_DEFAULT
        },
        hostname: 'test.sender.yandex-team.ru/api/0'
    },

    host: 'https://localhost.msup.yandex.',
    alternativeHost: 'https://www.localhost.msup.yandex.',
    indexHost: 'localhost.msup.yandex.',

    tvm: {
        destinations: [
            'blogs',
            'direct',
            'blackbox-testing',
            'blackbox-stress',
            'cmnt',
            'adv-backend'
        ]
    },

    regionsHosts: {
        cn: 'https://localhost.msup.yandex-ad.cn'
    },

    caseCategory: {
        id: '5d88e194392d5b002f1b4c85',
        parentCategoryId: '5c98bf970825df766988df10'
    },

    reactRender: {
        isHot: true
    },

    logger: {
        streams: [
            {
                level: 'info',
                stream: lineStream({
                    template: [
                        '{{date}}',
                        '{{levelName}}',
                        '{{msg}}',
                        '{{#err}}\n{{err.stack}}{{/err}}'
                    ].join(' ')
                })
            }
        ]
    },

    cmnt: {
        loader: 'https://test.yastat.net/comments/v1/comments.js',
        api: 'http://httpadapter-dev-common.n.yandex-team.ru/cmnt/v1',
        maxPostsSlugs: 5
    },

    commonMetrikaCounters: [
        {
            id: '76132642',
            tld: ['ru']
        }
    ]
};
