const _ = require('lodash');

module.exports = {
    static: {
        host: `https://yastatic.net/s3/vda/static/${process.env.APP_VERSION}`,
        dir: `${__dirname}/../out/public`
    },

    backend: {
        baseUrl: 'https://adv-backend-prod.in.yandex-team.ru/v1/'
    },

    bunker: {
        api: 'http://bunker-api.yandex.net/v1',
        version: 'stable',
        updateInterval: 15 * 60 * 1000
    },

    blackbox: {
        api: 'blackbox.yandex.net',
        getServiceTicket: req => _.get(req, 'tvm.tickets.blackbox-production.ticket')
    },

    passport: {
        host: {
            ru: 'passport.yandex.ru',
            com: 'passport.yandex.com',
            'com.tr': 'passport.yandex.com.tr',
            by: 'passport.yandex.by',
            kz: 'passport.yandex.kz'
        }
    },

    uatraits: {
        server: 'http://uatraits.qloud.yandex.ru'
    },

    blogs: {
        host: 'https://adv-blogs-pumpkin-prod.commerce-int.yandex-team.ru/v1',
        rss: 'https://yablogs-adv.common.yandex.ru',
        commentsMigration: 'http://adv-api.common.yandex.ru/v1'
    },

    langs: ['ru', 'en', 'be', 'zh-Hans', 'tr', 'uk'],

    dashboard: {
        interest: 'http://back.advq.yandex.ru/advertising-categories/stats.json',
        cpc: 'http://bssoap.yandex.ru/export/export_adv-stat.cgi'
    },

    direct: {
        hostname: 'intapi.direct.yandex.ru'
    },

    sources: {
        url: 'https://vda.yandex.net'
    },

    subscribe: {
        auth: {
            default: process.env.SUBSCRIPTION_KEY_DEFAULT,
            publishers: process.env.SUBSCRIPTION_KEY_PUBLISHERS,
            translation: process.env.SUBSCRIPTION_KEY_TRANSLATION
        },
        hostname: 'sender.yandex-team.ru/api/0'
    },

    tvm: {
        destinations: [
            'blogs',
            'direct',
            'blackbox-production',
            'cmnt',
            'adv-backend'
        ]
    },

    host: 'https://yandex.',

    alternativeHost: 'https://www.yandex.',

    regionsHosts: {
        cn: 'https://yandex-ad.cn'
    },

    indexHost: 'adv-prod.commerce-int.yandex.',

    checkForm: {
        url: 'http://checkform.so.yandex-team.ru/check'
    },

    static2: {
        baseUrl: 'https://yastatic.net/s3/vda/static2/',
        frozenPath: '_',
        version: process.env.APP_VERSION
    },

    csp: {
        presets: {
            cmnt: require('./csp/presets/ya-cmnt')
        }
    },

    caseCategory: {
        id: '5d0b78f5f557893cb97ce583',
        parentCategoryId: '5c98bf970825df766988df10'
    },

    commonMetrikaCounters: [
        {
            id: '1207744',
            tld: ['ru', 'com', 'com.tr', 'cn', 'kz', 'by'],
            params: {
                webvisor: true
            }
        },
        {
            id: '57877870',
            tld: ['by']
        },
        {
            id: '22683841',
            tld: ['cn']
        },
        {
            id: '57878116',
            tld: ['com']
        },
        {
            id: '61995757',
            tld: ['com.tr']
        },
        {
            id: '57877981',
            tld: ['kz']
        },
        {
            id: '58298776',
            tld: ['ru']
        },
        {
            id: '191494'
        }
    ],

    metrikaCounters: [
        {
            id: '48508490',
            section: 'direct',
            params: {}
        },
        {
            id: '48426590',
            section: 'adfox',
            params: {}
        },
        {
            id: '48426164',
            section: 'metrika',
            params: {}
        },
        {
            id: '48426563',
            section: 'webmaster',
            params: {}
        },
        {
            id: '48531356',
            section: 'media',
            params: {}
        },
        {
            id: '48531401',
            section: 'market',
            params: {}
        },
        {
            id: '48531272',
            section: 'appmetrica',
            params: {}
        },
        {
            id: '49312303',
            section: 'freelancers',
            params: {}
        },
        {
            id: '49312318',
            section: 'agency',
            params: {}
        },
        {
            id: '48426590',
            section: 'rsya',
            params: {}
        }
    ],

    statvalue: {
        metrika: {
            id: 55791187
        }
    },

    cmnt: {
        loader: 'https://yastatic.net/comments/v1/comments.js',
        api: 'https://common.apphost.yandex.net/cmnt/v1'
    },

    promos: {
        host: 'https://vda.yandex.net'
    }
};
