const _ = require('lodash');

module.exports = _.merge({},
    require('./testing'),
    {
        static: {
            host: '/vda/static',
            noCache: true
        },

        blogs: {
            host: 'https://yablogs-api-stress.common.yandex.ru/v1'
        },

        blackbox: {
            api: 'pass-stress-i1.sezam.yandex.net',
            getServiceTicket: req => _.get(req, 'tvm.tickets.blackbox-stress.ticket')
        },

        tvm: {
            destinations: [
                'blackbox-stress'
            ]
        }
    }
);
