const fs = require('fs');
const _ = require('lodash');

const countries = {
    '96': 'Германия',
    '102': 'Великобритания',
    '122': 'Словения',
    '123': 'Финляндия',
    '124': 'Франция',
    '125': 'Чехия',
    '126': 'Швейцария',
    '134': 'Китай',
    '135': 'Южная Корея',
    '149': 'Беларусь',
    '159': 'Казахстан',
    '171': 'Узбекистан',
    '179': 'Эстония',
    '180': 'Сербия',
    '181': 'Израиль',
    '187': 'Украина',
    '204': 'Испания',
    '205': 'Италия',
    '206': 'Латвия',
    '207': 'Киргизия',
    '210': 'Объединённые Арабские Эмираты',
    '225': 'Россия',
    '246': 'Греция',
    '983': 'Турция',
    '994': 'Индия',
    '10105': 'Сингапур',
    '20574': 'Кипр',
    '21289': 'Уругвай'
};

const cities = {
    '1': 'Московская обл.',
    '2': 'Санкт-Петербург',
    '5': 'Иваново',
    '6': 'Калуга',
    '7': 'Кострома',
    '8': 'Курск',
    '9': 'Липецк',
    '11': 'Рязань',
    '12': 'Смоленск',
    '13': 'Тамбов',
    '14': 'Тверь',
    '15': 'Тула',
    '16': 'Ярославль',
    '21': 'Вологда',
    '22': 'Калининград',
    '24': 'Великий Новгород',
    '25': 'Псков',
    '35': 'Краснодар',
    '36': 'Ставрополь',
    '37': 'Астрахань',
    '38': 'Волгоград',
    '39': 'Ростов-на-Дону',
    '41': 'Йошкар-Ола',
    '43': 'Казань',
    '44': 'Ижевск',
    '45': 'Чебоксары',
    '46': 'Киров',
    '47': 'Нижний Новгород',
    '48': 'Оренбург',
    '49': 'Пенза',
    '50': 'Пермь',
    '51': 'Самара',
    '54': 'Екатеринбург',
    '55': 'Тюмень',
    '56': 'Челябинск',
    '62': 'Красноярск',
    '63': 'Иркутск',
    '64': 'Кемерово',
    '65': 'Новосибирск',
    '66': 'Омск',
    '67': 'Томск',
    '75': 'Владивосток',
    '76': 'Хабаровск',
    '99': 'Мюнхен',
    '100': 'Франкфурт-на-Майне',
    '143': 'Киев',
    '145': 'Одесса',
    '147': 'Харьков',
    '148': 'Николаев',
    '154': 'Витебск',
    '157': 'Минск',
    '162': 'Алматы',
    '164': 'Караганда',
    '172': 'Уфа',
    '177': 'Берлин',
    '178': 'Гамбург',
    '191': 'Брянск',
    '193': 'Воронеж',
    '194': 'Саратов',
    '195': 'Ульяновск',
    '197': 'Барнаул',
    '213': 'Москва',
    '219': 'Черноголовка',
    '236': 'Набережные Челны',
    '237': 'Новокузнецк',
    '238': 'Новочеркасск',
    '239': 'Сочи',
    '240': 'Тольятти',
    '959': 'Севастополь',
    '967': 'Обнинск',
    '968': 'Череповец',
    '973': 'Сургут',
    '10295': 'Костанай',
    '10309': 'Бишкек',
    '10335': 'Ташкент',
    '10393': 'Лондон',
    '10397': 'Edinburgh',
    '10418': 'Афины',
    '10429': 'Барселона',
    '10435': 'Мадрид',
    '10445': 'Рим',
    '10448': 'Милан',
    '10451': 'Венеция',
    '10458': 'Пиза',
    '10492': 'Любляна',
    '10493': 'Хельсинки',
    '10502': 'Париж',
    '10511': 'Прага',
    '10514': 'Geneva',
    '10515': 'Цюрих',
    '10522': 'Белград',
    '10558': 'Мумбаи',
    '10584': 'Гонконг',
    '10590': 'Beijing',
    '10592': 'Taipei',
    '10594': 'Urumqi',
    '10599': 'Шанхай',
    '10619': 'Сингапур',
    '10635': 'Сеул',
    '10738': 'Люберцы',
    '11067': 'Пятигорск',
    '11212': 'Миасс',
    '11474': 'Рига',
    '11481': 'Таллин',
    '11499': 'Dubai',
    '11508': 'Стамбул',
    '20222': 'Луцк',
    '20575': 'Никосия',
    '20577': 'Jinan',
    '20833': 'Shijiazhuang',
    '21084': 'Suzhou',
    '21099': 'Уси',
    '21159': 'Лимасол',
    '21177': 'Luoyang',
    '21274': 'Мозырь',
    '21290': 'Монтевидео',
    '21431': 'Guangzhou',
    '37181': 'Zhengzhou',
    '101063': 'Котка',
    '101431': 'Тревизо',
    '101516': 'Лаппеэнранта',
    '103773': 'Аугсбург',
    '104999': 'Лидс',
    '105089': 'Злин',
    '109082': 'Лугано',
    '109370': 'Нинбо',
    '109371': 'Shenzhen',
    '109372': 'Вэньчжоу',
    '109506': 'Брайтон',
    '109582': 'Йорк',
    '112792': 'Карпи',
    '114575': 'Шаньдун',
    '121220': 'Симферополь'
};

/* eslint-disable camelcase */
function proceedAgency (agency, key) {
    const {
        name,
        site,
        disabled,
        certificates,
        login_glv,
        login_market,
        login_metrika,
        addresses
    } = agency;

    const [{ country, city }] = addresses;

    if (!countries[country]) {
        throw Error(`no country name for code ${country}`);
    }

    if (!cities[city]) {
        throw Error(`no city name for code ${city}`);
    }

    return {
        key,
        name,
        site,
        disabled,
        country: countries[country],
        city: cities[city],
        certificates,
        login_glv,
        login_market,
        login_metrika
    };
}
/* eslint-enable camelcase */

function exportAgencies() {
    const bunker = JSON.parse(fs.readFileSync('server/tmp/bunker.json', 'utf8'));

    const agencies = {
        russia: _.map(bunker.agencies.russia, proceedAgency),
        belarus: _.map(bunker.agencies.belarus, proceedAgency)
    };

    const filename = `./agencies_${Date.now()}.json`;

    fs.writeFile(filename, JSON.stringify(agencies), 'utf8', err => {
        if (err) {
            console.log(err);
        } else {
            console.log(`Данные об агенствах были сохранены в файл: ${filename}`);
        }
    });
}

exportAgencies();

