const fs = require('fs');

function getSQL(countryGeoId, cityGeoIds) {
    const rawCityGeoIds = cityGeoIds.join(', ');

    return 'UPDATE backend_city\r\n' +
           'SET country_id = ' +
           `(SELECT id from backend_country WHERE geo_id = ${countryGeoId})\r\n` +
           `WHERE geo_id in (${rawCityGeoIds});\r\n\r\n`;
}

function getCitiesByCountries() {
    const data = fs.readFileSync('./data.json');

    return JSON.parse(data).citiesByCountries;
}

function generateSQL() {
    const citiesByCountries = getCitiesByCountries();

    for (const country of citiesByCountries) {
        const cityGeoIds = country.cities.map(city => city.geo_id);

        const countrySql = getSQL(country.geo_id, cityGeoIds);

        fs.writeFileSync('./sqlScript.sql', countrySql, { flag: 'a' });
    }
}

generateSQL();
