const _ = require('lodash');
const fs = require('fs');
const got = require('got');
const url = require('url');
const shortid = require('shortid');

const bunker = fs.readFileSync('./server/tmp/bunker.json');
const result = {};

async function uploadFile(oldUrl) {
    const putUrl = url.format({
        protocol: 'http',
        hostname: 'avatars-int.mds.yandex.net',
        port: 13000,
        pathname: `put-adv/${shortid.generate()}`,
        query: {
            url: encodeURI(oldUrl)
        }
    });
    let response = {};

    try {
        console.log('request to', putUrl);
        response = await got.get(putUrl, { json: true });
    } catch (e) {
        console.error(e);
    }

    console.log('done', _.get(response, 'body.sizes.orig.path'));

    return url.format({
        protocol: 'https',
        hostname: 'avatars.mds.yandex.net',
        pathname: _.get(response, 'body.sizes.orig.path')
    });
}

(async () => {
    const bunkerData = JSON.parse(bunker);
    const rootNode = _.get(bunkerData, 'sources.ru.solutions', {});
    const nodes = _.pick(rootNode, ['analytics', 'cases', 'others', 'stories', 'practicums']);

    for (const sectionName of Object.keys(nodes)) {
        const section = nodes[sectionName];

        for (const pageName of Object.keys(section)) {
            const page = section[pageName];

            if (!_.isObject(page) || _.isArray(page) || !page.enabled) {
                continue;
            }

            const uploadedFileUrl = await uploadFile(page.image);

            _.set(result, [sectionName, pageName], uploadedFileUrl);
        }
    }

    console.log(result);
})();
