#!/bin/bash
# https://<user_name>-<project_id>-ekb.ldev.yandex.ru/
# ./tunnel.sh ekb-tunneler.ldev.yandex-team.ru 443 <project_id>
set -e
if [ -z $3 ]; then
    echo "Usage: ./tunnel.sh <tunneler_host> <local_port> <project_id>"
    exit -1
fi
echo "Asking $1 for instance list"
IFS=',' INST=($(curl -k "https://$1/api/v1/instances?format=ipv6" | tr -d [] | awk '{FS=","; print $0 }' | tr -d '"'))
HOST=${INST[0]}
PORT=${INST[1]}
echo "Connecting to ${HOST}:${PORT}"
echo "Starting on https://${USER}-${3}-ekb.ldev.yandex.ru/"
ssh -o UserKnownHostsFile=/dev/null  -o LogLevel=ERROR -o StrictHostKeyChecking=no -N -R "$3:localhost:$2" -p $PORT $HOST
